/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.TrustType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;

public class SAML2IssuerTrustHandler
extends BaseSAML2Handler {
    private final IDPTrustHandler idp = new IDPTrustHandler();
    private final SPTrustHandler sp = new SPTrustHandler();

    @Override
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleRequestType(request, response, (IDPType)this.handlerChainConfig.getParameter("CONFIGURATION"));
        } else {
            this.sp.handleRequestType(request, response, (ProviderType)this.handlerChainConfig.getParameter("CONFIGURATION"));
        }
    }

    @Override
    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleStatusResponseType(request, response, (IDPType)this.handlerChainConfig.getParameter("CONFIGURATION"));
        } else {
            this.sp.handleStatusResponseType(request, response, (ProviderType)this.handlerChainConfig.getParameter("CONFIGURATION"));
        }
    }

    private static String getDomain(String domainURL) throws IOException {
        try {
            URL url = new URL(domainURL);
            return url.getHost();
        }
        catch (MalformedURLException me) {
            try {
                domainURL = "http://" + domainURL;
                URL url = new URL(domainURL);
                return url.getHost();
            }
            catch (Exception e) {
                return domainURL;
            }
        }
    }

    private class SPTrustHandler {
        private SPTrustHandler() {
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response, ProviderType spConfiguration) throws ProcessingException {
            RequestAbstractType statusResponseType = (RequestAbstractType)request.getSAML2Object();
            String issuer = statusResponseType.getIssuer().getValue();
            this.trustIssuer(spConfiguration, request, issuer);
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response, ProviderType spConfiguration) throws ProcessingException {
            StatusResponseType statusResponseType = (StatusResponseType)request.getSAML2Object();
            String issuer = statusResponseType.getIssuer().getValue();
            this.trustIssuer(spConfiguration, request, issuer);
        }

        private void trustIssuer(ProviderType spConfiguration, SAML2HandlerRequest request, String issuer) throws ProcessingException {
            block7: {
                if (spConfiguration == null) {
                    throw BaseSAML2Handler.logger.nullArgumentError("SP Configuration");
                }
                Map<String, Object> requestOptions = request.getOptions();
                PicketLinkAuditHelper auditHelper = (PicketLinkAuditHelper)requestOptions.get("AUDIT_HELPER");
                String contextPath = (String)requestOptions.get("CONTEXT_PATH");
                try {
                    String issuerDomain = SAML2IssuerTrustHandler.getDomain(issuer);
                    TrustType spTrust = spConfiguration.getTrust();
                    if (spTrust != null) {
                        String domainsTrusted = spTrust.getDomains();
                        BaseSAML2Handler.logger.trace("Domains that SP trusts = " + domainsTrusted + " and issuer domain = " + issuerDomain);
                        if (domainsTrusted.indexOf(issuerDomain) < 0) {
                            StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                            while (st != null && st.hasMoreTokens()) {
                                String uriBit = st.nextToken();
                                BaseSAML2Handler.logger.trace("Matching uri bit = " + uriBit);
                                if (issuerDomain.indexOf(uriBit) <= 0) continue;
                                BaseSAML2Handler.logger.trace("Matched " + uriBit + " trust for " + issuerDomain);
                                return;
                            }
                            if (auditHelper != null) {
                                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                                auditEvent.setWhoIsAuditing(contextPath);
                                auditEvent.setType(PicketLinkAuditEventType.ERROR_TRUSTED_DOMAIN);
                                auditHelper.audit(auditEvent);
                            }
                            throw BaseSAML2Handler.logger.samlIssuerNotTrustedError(issuer);
                        }
                        break block7;
                    }
                    throw BaseSAML2Handler.logger.samlHandlerTrustElementMissingError();
                }
                catch (Exception e) {
                    throw new ProcessingException((Throwable)BaseSAML2Handler.logger.samlIssuerNotTrustedException((Throwable)e));
                }
            }
        }
    }

    private class IDPTrustHandler {
        private IDPTrustHandler() {
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response, IDPType idpConfiguration) throws ProcessingException {
            RequestAbstractType requestType = (RequestAbstractType)request.getSAML2Object();
            if (requestType == null) {
                throw BaseSAML2Handler.logger.nullValueError("AuthnRequest");
            }
            String issuer = requestType.getIssuer().getValue();
            this.trustIssuer(idpConfiguration, issuer);
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response, IDPType idpConfiguration) throws ProcessingException {
            String issuer = request.getIssuer().getValue();
            this.trustIssuer(idpConfiguration, issuer);
        }

        private void trustIssuer(IDPType idpConfiguration, String issuer) throws ProcessingException {
            block6: {
                if (idpConfiguration == null) {
                    throw BaseSAML2Handler.logger.nullArgumentError("IDP Configuration");
                }
                try {
                    String issuerDomain = SAML2IssuerTrustHandler.getDomain(issuer);
                    TrustType idpTrust = idpConfiguration.getTrust();
                    if (idpTrust != null && idpTrust.getDomains() != null) {
                        String domainsTrusted = idpTrust.getDomains();
                        BaseSAML2Handler.logger.trace("Domains that IDP trusts = " + domainsTrusted + " and issuer domain = " + issuerDomain);
                        if (domainsTrusted.indexOf(issuerDomain) < 0) {
                            StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                            while (st != null && st.hasMoreTokens()) {
                                String uriBit = st.nextToken();
                                BaseSAML2Handler.logger.trace("Matching uri bit = " + uriBit);
                                if (issuerDomain.indexOf(uriBit) <= 0) continue;
                                BaseSAML2Handler.logger.trace("Matched " + uriBit + " trust for " + issuerDomain);
                                return;
                            }
                            throw BaseSAML2Handler.logger.samlIssuerNotTrustedError(issuer);
                        }
                        break block6;
                    }
                    throw BaseSAML2Handler.logger.samlHandlerTrustElementMissingError();
                }
                catch (Exception e) {
                    throw new ProcessingException((Throwable)BaseSAML2Handler.logger.samlIssuerNotTrustedException((Throwable)e));
                }
            }
        }
    }
}

