/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.handler.Handler;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.util.SecurityActions;

public class HandlerUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static Set<SAML2Handler> getHandlers(Handlers handlers) throws ConfigurationException {
        if (handlers == null) {
            throw logger.nullArgumentError("handlers");
        }
        List handlerList = handlers.getHandler();
        LinkedHashSet<SAML2Handler> handlerSet = new LinkedHashSet<SAML2Handler>();
        for (Handler handler : handlerList) {
            SAML2Handler samlhandler = HandlerUtil.createInstance(handler);
            List options = handler.getOption();
            HashMap<String, Object> mapOptions = new HashMap<String, Object>();
            for (KeyValueType kvtype : options) {
                mapOptions.put(kvtype.getKey(), kvtype.getValue());
            }
            DefaultSAML2HandlerConfig handlerConfig = new DefaultSAML2HandlerConfig();
            handlerConfig.set(mapOptions);
            samlhandler.initHandlerConfig(handlerConfig);
            handlerSet.add(samlhandler);
        }
        return handlerSet;
    }

    private static SAML2Handler createInstance(Handler handler) throws ConfigurationException {
        String clazzName;
        Class<?> clazz = handler.getType();
        if (clazz == null && (clazz = SecurityActions.loadClass(HandlerUtil.class, clazzName = handler.getClazz())) == null) {
            throw logger.configurationError((Throwable)logger.classNotLoadedError(clazzName));
        }
        try {
            return (SAML2Handler)clazz.newInstance();
        }
        catch (Exception e) {
            throw logger.configurationError((Throwable)e);
        }
    }
}

