/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;

public class AbstractJDBCRegistry {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected DataSource dataSource;

    public AbstractJDBCRegistry() {
        this("jdbc/picketlink-sts");
    }

    public AbstractJDBCRegistry(String jndiName) {
        try {
            InitialContext initContext = new InitialContext();
            Context envContext = (Context)initContext.lookup("java:comp/env");
            this.dataSource = (DataSource)envContext.lookup(jndiName);
            if (this.dataSource == null) {
                throw logger.datasourceIsNull();
            }
        }
        catch (NamingException e) {
            throw logger.jbdcInitializationError(e);
        }
    }

    protected void safeClose(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void safeClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void safeClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

