/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;

public class SAMLProtocolContext
implements ProtocolContext {
    protected NameIDType issuerID;
    protected SubjectType subjectType;
    protected ConditionsType conditions;
    protected List<StatementAbstractType> statements = new ArrayList<StatementAbstractType>();
    protected AssertionType issuedAssertion;

    public NameIDType getIssuerID() {
        return this.issuerID;
    }

    public void setIssuerID(NameIDType issuerID) {
        this.issuerID = issuerID;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public ConditionsType getConditions() {
        return this.conditions;
    }

    public void setConditions(ConditionsType conditions) {
        this.conditions = conditions;
    }

    public List<StatementAbstractType> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public void setStatements(List<StatementAbstractType> statements) {
        this.statements = statements;
    }

    public AssertionType getIssuedAssertion() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        return this.issuedAssertion;
    }

    public void setIssuedAssertion(AssertionType issuedAssertion) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        this.issuedAssertion = issuedAssertion;
    }

    @Override
    public String serviceName() {
        return null;
    }

    @Override
    public String tokenType() {
        return JBossSAMLURIConstants.ASSERTION_NSURI.get();
    }

    @Override
    public QName getQName() {
        String localPart = JBossSAMLConstants.ASSERTION.get();
        String ns = this.tokenType();
        return new QName(ns, localPart);
    }

    @Override
    public String family() {
        return SecurityTokenProvider.FAMILY_TYPE.SAML2.toString();
    }
}

