/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml.xacml;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.saml.SAMLRequestAbstractParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.saml.v2.protocol.XACMLAuthzDecisionQueryType;
import org.w3c.dom.Element;

public class SAMLXACMLRequestParser
extends SAMLRequestAbstractParser
implements ParserNamespaceSupport {
    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
        String tag = StaxParserUtil.getStartElementName(startElement);
        if (tag.equalsIgnoreCase("MessageBody")) {
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        }
        startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        if (tag.equals(JBossSAMLConstants.REQUEST_ABSTRACT.get())) {
            String xsiTypeValue = StaxParserUtil.getXSITypeValue(startElement);
            if (xsiTypeValue.contains(JBossSAMLConstants.XACML_AUTHZ_DECISION_QUERY_TYPE.get())) {
                return this.parseXACMLAuthzDecisionQuery(startElement, xmlEventReader);
            }
            throw logger.parserUnknownXSI(xsiTypeValue);
        }
        if (tag.equals(JBossSAMLConstants.XACML_AUTHZ_DECISION_QUERY.get())) {
            return this.parseXACMLAuthzDecisionQuery(startElement, xmlEventReader);
        }
        throw logger.parserUnknownStartElement(tag, startElement.getLocation());
    }

    @Override
    public boolean supports(QName qname) {
        return false;
    }

    private XACMLAuthzDecisionQueryType parseXACMLAuthzDecisionQuery(StartElement startElement, XMLEventReader xmlEventReader) throws ParsingException {
        String returnContext;
        super.parseRequiredAttributes(startElement);
        XACMLAuthzDecisionQueryType xacmlQuery = new XACMLAuthzDecisionQueryType(this.id, this.issueInstant);
        super.parseBaseAttributes(startElement, xacmlQuery);
        String inputContextOnly = StaxParserUtil.getAttributeValue(startElement, JBossSAMLConstants.INPUT_CONTEXT_ONLY.get());
        if (inputContextOnly != null) {
            xacmlQuery.setInputContextOnly(Boolean.parseBoolean(inputContextOnly));
        }
        if ((returnContext = StaxParserUtil.getAttributeValue(startElement, JBossSAMLConstants.RETURN_CONTEXT.get())) != null) {
            xacmlQuery.setReturnContext(Boolean.parseBoolean(returnContext));
        }
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xmlEvent;
                if (StaxParserUtil.matches(endElement, JBossSAMLConstants.REQUEST_ABSTRACT.get()) || StaxParserUtil.matches(endElement, JBossSAMLConstants.XACML_AUTHZ_DECISION_QUERY.get())) break;
                throw logger.parserExpectedEndTag("RequestAbstract or XACMLAuthzDecisionQuery");
            }
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (startElement == null) break;
            super.parseCommonElements(startElement, xmlEventReader, xacmlQuery);
            String tag = StaxParserUtil.getStartElementName(startElement);
            if (!tag.equals(JBossSAMLConstants.REQUEST.get())) continue;
            Element xacmlRequest = StaxParserUtil.getDOMElement(xmlEventReader);
            String xacmlPath = "org.jboss.security.xacml.core.model.context";
            try {
                JAXBContext jaxb = JAXBContext.newInstance((String)xacmlPath);
                Unmarshaller un = jaxb.createUnmarshaller();
                un.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
                JAXBElement jaxbRequestType = (JAXBElement)un.unmarshal(DocumentUtil.getNodeAsStream(xacmlRequest));
                RequestType req = (RequestType)jaxbRequestType.getValue();
                xacmlQuery.setRequest(req);
            }
            catch (Exception e) {
                throw logger.parserException(e);
            }
        }
        return xacmlQuery;
    }
}

