/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.metadata;

import java.math.BigInteger;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyTypes;
import org.picketlink.identity.xmlsec.w3.xmlenc.EncryptionMethodType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyDescriptorMetaDataBuilder {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static KeyDescriptorType createKeyDescriptor(Element keyInfo, String algorithm, int keySize, boolean isSigningKey, boolean isEncryptionKey) {
        if (keyInfo == null) {
            throw logger.nullArgumentError("keyInfo");
        }
        if (isSigningKey == isEncryptionKey) {
            throw logger.shouldNotBeTheSameError("Only one of isSigningKey and isEncryptionKey should be true");
        }
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        if (StringUtil.isNotNull(algorithm)) {
            EncryptionMethodType encryptionMethod = new EncryptionMethodType(algorithm);
            encryptionMethod.setEncryptionMethod(new EncryptionMethodType.EncryptionMethod(BigInteger.valueOf(keySize), null));
            keyDescriptor.addEncryptionMethod(encryptionMethod);
        }
        if (isSigningKey) {
            keyDescriptor.setUse(KeyTypes.SIGNING);
        }
        if (isEncryptionKey) {
            keyDescriptor.setUse(KeyTypes.ENCRYPTION);
        }
        keyDescriptor.setKeyInfo(keyInfo);
        return keyDescriptor;
    }

    public static KeyDescriptorType createKeyDescriptor(Element keyInfo, String algorithm, int keySize) {
        if (keyInfo == null) {
            throw logger.nullArgumentError("keyInfo");
        }
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        if (StringUtil.isNotNull(algorithm)) {
            EncryptionMethodType encryptionMethod = new EncryptionMethodType(algorithm);
            encryptionMethod.setEncryptionMethod(new EncryptionMethodType.EncryptionMethod(BigInteger.valueOf(keySize), null));
            keyDescriptor.addEncryptionMethod(encryptionMethod);
        }
        keyDescriptor.setKeyInfo(keyInfo);
        return keyDescriptor;
    }

    public static KeyDescriptorType createKeyDescriptor(Element keyDescriptorElement) {
        if (keyDescriptorElement == null) {
            throw logger.nullArgumentError("keyDescriptorElement");
        }
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        String use = keyDescriptorElement.getAttribute("use");
        if (use != null && !use.isEmpty()) {
            keyDescriptor.setUse(KeyTypes.fromValue(use));
        }
        Element keyInfoElement = (Element)keyDescriptorElement.getElementsByTagNameNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), JBossSAMLConstants.KEY_INFO.get()).item(0);
        keyDescriptor.setKeyInfo(keyInfoElement);
        NodeList nl = keyDescriptorElement.getElementsByTagNameNS(JBossSAMLURIConstants.METADATA_NSURI.get(), "EncryptionMethod");
        for (int i = 0; i < nl.getLength(); ++i) {
            String algo = ((Element)nl.item(i)).getAttribute("Algorithm");
            keyDescriptor.addEncryptionMethod(new EncryptionMethodType(algo));
        }
        return keyDescriptor;
    }
}

