/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityIdentity;
import org.jboss.security.SubjectInfo;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.RoleGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityContextUtil {
    protected SecurityContext securityContext = null;

    public void setSecurityContext(SecurityContext sc) {
        this.securityContext = sc;
    }

    public abstract String getUserName();

    public abstract Principal getUserPrincipal();

    public abstract Object getCredential();

    public abstract Subject getSubject();

    public abstract SecurityIdentity getSecurityIdentity();

    public abstract void setSecurityIdentity(SecurityIdentity var1);

    public abstract RoleGroup getRoles();

    public abstract void setRoles(RoleGroup var1);

    public void createSubjectInfo(Principal principal, Object credential, Subject subject) {
        SubjectInfo si = new SubjectInfo(principal, credential, subject);
        this.securityContext.setSubjectInfo(si);
    }

    public void createSubjectInfo(Identity identity, Subject theSubject) {
        this.securityContext.setSubjectInfo(new SubjectInfo(identity, theSubject));
    }

    public void addIdentity(Identity id) {
        this.securityContext.getSubjectInfo().addIdentity(id);
    }

    public void clearIdentities(Class<?> clazz) {
        Set<Identity> ids = this.securityContext.getSubjectInfo().getIdentities();
        if (ids != null) {
            for (Identity id : ids) {
                if (!clazz.isAssignableFrom(id.getClass())) continue;
                this.securityContext.getSubjectInfo().removeIdentity(id);
            }
        }
    }

    public Set<Identity> getIdentities(Class<?> clazz) {
        HashSet<Identity> resultSet = new HashSet<Identity>();
        Set<Identity> ids = this.securityContext.getSubjectInfo().getIdentities();
        if (ids != null) {
            for (Identity id : ids) {
                if (!clazz.isAssignableFrom(id.getClass())) continue;
                resultSet.add(id);
            }
        }
        return resultSet;
    }

    public void setIdentities(Set<Identity> idSet) {
        this.securityContext.getSubjectInfo().setIdentities(idSet);
    }

    public abstract <T> void set(String var1, T var2);

    public abstract <T> T get(String var1);

    public abstract <T> T remove(String var1);
}

