/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.lang.reflect.Constructor;
import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SecuritySPIActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityContextFactory {
    private static final Class[] CONTEXT_CONSTRUCTOR_TYPES = new Class[]{String.class};
    private static final Class[] CONTEXT_UTIL_CONSTRUCTOR_TYPES = new Class[]{SecurityContext.class};
    private static String defaultFQN = "org.jboss.security.plugins.JBossSecurityContext";
    private static String defaultUtilClassFQN = "org.jboss.security.plugins.JBossSecurityContextUtil";
    private static Class<? extends SecurityContext> defaultSecurityContextClass = null;
    private static Constructor<SecurityContext> defaultSecurityContextConstructor = null;
    private static Class<? extends SecurityContextUtil> defaultUtilClass = null;
    private static Constructor<SecurityContextUtil> defaultUtilConstructor = null;

    public static SecurityContext createSecurityContext(String securityDomain) throws Exception {
        if (defaultSecurityContextConstructor != null) {
            return SecurityContextFactory.createSecurityContext(securityDomain, defaultSecurityContextConstructor);
        }
        if (defaultSecurityContextClass != null) {
            return SecurityContextFactory.createSecurityContext(securityDomain, defaultSecurityContextClass);
        }
        return SecurityContextFactory.createSecurityContext(securityDomain, defaultFQN, SecuritySPIActions.getCurrentClassLoader(SecurityContextFactory.class));
    }

    public static SecurityContext createSecurityContext(String securityDomain, ClassLoader classLoader) throws Exception {
        if (defaultSecurityContextConstructor != null) {
            return SecurityContextFactory.createSecurityContext(securityDomain, defaultSecurityContextConstructor);
        }
        if (defaultSecurityContextClass != null) {
            return SecurityContextFactory.createSecurityContext(securityDomain, defaultSecurityContextClass);
        }
        return SecurityContextFactory.createSecurityContext(securityDomain, defaultFQN, classLoader);
    }

    public static SecurityContext createSecurityContext(String securityDomain, String fqnClass) throws Exception {
        return SecurityContextFactory.createSecurityContext(securityDomain, fqnClass, SecuritySPIActions.getCurrentClassLoader(SecurityContextFactory.class));
    }

    public static SecurityContext createSecurityContext(String securityDomain, String fqnClass, ClassLoader classLoader) throws Exception {
        if (securityDomain == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("security domain");
        }
        if (fqnClass == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("fqnClass");
        }
        defaultSecurityContextClass = SecurityContextFactory.getContextClass(fqnClass, classLoader);
        defaultSecurityContextConstructor = defaultSecurityContextClass.getConstructor(CONTEXT_CONSTRUCTOR_TYPES);
        return SecurityContextFactory.createSecurityContext(securityDomain, defaultSecurityContextConstructor);
    }

    public static SecurityContext createSecurityContext(String securityDomain, Class<? extends SecurityContext> clazz) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityContextFactory.class.getName() + ".createSecurityContext"));
        }
        if (securityDomain == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("security domain");
        }
        if (clazz == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("clazz");
        }
        Constructor<? extends SecurityContext> ctr = clazz.getConstructor(CONTEXT_CONSTRUCTOR_TYPES);
        return ctr.newInstance(securityDomain);
    }

    private static SecurityContext createSecurityContext(String securityDomain, Constructor<SecurityContext> constructor) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityContextFactory.class.getName() + ".createSecurityContext"));
        }
        if (securityDomain == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("security domain");
        }
        if (constructor == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("constructor");
        }
        return constructor.newInstance(securityDomain);
    }

    public static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String securityDomain) throws Exception {
        return SecurityContextFactory.createSecurityContext(p, cred, s, securityDomain, SecuritySPIActions.getCurrentClassLoader(SecurityContextFactory.class));
    }

    public static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String securityDomain, ClassLoader classLoader) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityContextFactory.class.getName() + ".createSecurityContext"));
        }
        SecurityContext jsc = SecurityContextFactory.createSecurityContext(securityDomain, classLoader);
        jsc.getUtil().createSubjectInfo(p, cred, s);
        return jsc;
    }

    public static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String securityDomain, String fqnClass, ClassLoader classLoader) throws Exception {
        SecurityContext sc = SecurityContextFactory.createSecurityContext(securityDomain, fqnClass, classLoader);
        sc.getUtil().createSubjectInfo(p, cred, s);
        return sc;
    }

    public static SecurityContextUtil createUtil(SecurityContext sc) throws Exception {
        return SecurityContextFactory.createUtil(sc, SecuritySPIActions.getCurrentClassLoader(SecurityContextFactory.class));
    }

    public static SecurityContextUtil createUtil(SecurityContext sc, ClassLoader classLoader) throws Exception {
        Constructor<SecurityContextUtil> ctr;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityContextFactory.class.getName() + ".createUtil"));
        }
        if ((ctr = defaultUtilConstructor) == null) {
            Class<?> clazz = SecurityContextFactory.loadClass(defaultUtilClassFQN, classLoader);
            defaultUtilClass = clazz;
            ctr = defaultUtilConstructor = clazz.getConstructor(CONTEXT_UTIL_CONSTRUCTOR_TYPES);
        }
        return ctr.newInstance(sc);
    }

    public static SecurityContextUtil createUtil(SecurityContext sc, String utilFQN) throws Exception {
        return SecurityContextFactory.createUtil(sc, utilFQN, SecuritySPIActions.getCurrentClassLoader(SecurityContextFactory.class));
    }

    public static SecurityContextUtil createUtil(SecurityContext sc, String utilFQN, ClassLoader classLoader) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityContextFactory.class.getName() + ".createUtil"));
        }
        Class<?> clazz = SecurityContextFactory.loadClass(utilFQN, classLoader);
        Constructor<?> ctr = clazz.getConstructor(CONTEXT_UTIL_CONSTRUCTOR_TYPES);
        return (SecurityContextUtil)ctr.newInstance(sc);
    }

    public static SecurityContextUtil createUtil(SecurityContext sc, Class<? extends SecurityContextUtil> utilClazz) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityContextFactory.class.getName() + ".createUtil"));
        }
        Constructor<? extends SecurityContextUtil> ctr = utilClazz.getConstructor(SecurityContext.class);
        return ctr.newInstance(sc);
    }

    public static void setDefaultSecurityContextFQN(String fqn) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityContextFactory.class.getName() + ".setDefaultSecurityContextFQN"));
        }
        defaultFQN = fqn;
        defaultSecurityContextClass = null;
        defaultSecurityContextConstructor = null;
    }

    public static void setDefaultSecurityContextUtilFQN(String fqn) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityContextFactory.class.getName() + ".setDefaultSecurityContextUtilFQN"));
        }
        defaultUtilClassFQN = fqn;
        defaultUtilClass = null;
        defaultUtilConstructor = null;
    }

    private static Class<?> loadClass(String fqn, ClassLoader classLoader) throws Exception {
        try {
            return classLoader.loadClass(fqn);
        }
        catch (Exception e) {
            ClassLoader tcl = SecuritySPIActions.getContextClassLoader();
            return tcl.loadClass(fqn);
        }
    }

    private static Class<SecurityContext> getContextClass(String className, ClassLoader classLoader) throws Exception {
        try {
            return classLoader.loadClass(className);
        }
        catch (Exception e) {
            ClassLoader tcl = SecuritySPIActions.getContextClassLoader();
            return tcl.loadClass(className);
        }
    }

    static {
        try {
            defaultSecurityContextClass = SecuritySPIActions.getCurrentClassLoader(SecurityContextFactory.class).loadClass(defaultFQN);
        }
        catch (Exception ignore) {
            try {
                defaultSecurityContextClass = SecuritySPIActions.getContextClassLoader().loadClass(defaultFQN);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            defaultUtilClass = SecuritySPIActions.getCurrentClassLoader(SecurityContextFactory.class).loadClass(defaultUtilClassFQN);
        }
        catch (Exception ignore) {
            try {
                defaultUtilClass = SecuritySPIActions.getContextClassLoader().loadClass(defaultUtilClassFQN);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defaultSecurityContextClass != null) {
            try {
                defaultSecurityContextConstructor = defaultSecurityContextClass.getConstructor(CONTEXT_CONSTRUCTOR_TYPES);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

