/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.plugins.PersistenceStrategy;

public class FilePersistenceStrategy
implements PersistenceStrategy {
    private String path;

    public FilePersistenceStrategy(String path) {
        this.path = path;
    }

    public Identity persistIdentity(Identity identity) {
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            File file = new File(String.valueOf(this.path) + File.separator + identity.getName());
            if (file.exists()) {
                return null;
            }
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(identity);
            Identity identity2 = identity;
            this.safeClose(oos);
            this.safeClose(fos);
            return identity2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.safeClose(oos);
            this.safeClose(fos);
        }
    }

    public Identity getIdentity(String name) {
        ObjectInputStream ois = null;
        FileInputStream fis = null;
        try {
            Identity identity;
            fis = new FileInputStream(String.valueOf(this.path) + File.separator + name);
            ois = new ObjectInputStream(fis);
            Identity identity2 = identity = (Identity)ois.readObject();
            this.safeClose(ois);
            this.safeClose(fis);
            return identity2;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(ois);
                this.safeClose(fis);
                throw throwable;
            }
        }
    }

    public boolean removeIdentity(Identity identity) {
        File file = new File(String.valueOf(this.path) + File.separator + identity.getName());
        return file.delete();
    }

    public Identity updateIdentity(Identity identity) {
        if (this.removeIdentity(identity)) {
            return this.persistIdentity(identity);
        }
        return null;
    }

    private void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

