/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.plugins.authorization;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.AuthorizationModule;
import org.jboss.security.authorization.Resource;
import org.jboss.security.identity.RoleGroup;

public class PicketBoxAuthorizationModule
implements AuthorizationModule {
    private Set<String> rolesSet = new HashSet<String>();
    private Subject subject = null;

    public boolean abort() throws AuthorizationException {
        return true;
    }

    public int authorize(Resource resource) {
        Set<Principal> principals = this.subject.getPrincipals();
        for (Principal p : principals) {
            Group group;
            if (!(p instanceof Group) || !(group = (Group)p).getName().equalsIgnoreCase("Roles")) continue;
            Enumeration roles = group.members();
            while (roles.hasMoreElements()) {
                Principal role = (Principal)roles.nextElement();
                if (!this.rolesSet.contains(role.getName())) continue;
                return 1;
            }
        }
        return -1;
    }

    public boolean commit() throws AuthorizationException {
        return true;
    }

    public boolean destroy() {
        return true;
    }

    public void initialize(Subject subject, CallbackHandler handler, Map<String, Object> sharedState, Map<String, Object> options, RoleGroup roles) {
        String configuredRoles = (String)options.get("roles");
        this.getRoles(configuredRoles);
        this.subject = subject;
    }

    private void getRoles(String commaStr) {
        StringTokenizer st = new StringTokenizer(commaStr, ",");
        while (st.hasMoreTokens()) {
            this.rolesSet.add(st.nextToken());
        }
    }
}

