/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.config.parser.StaxBasedConfigParser;
import org.picketbox.config.SecurityActions;
import org.picketbox.exceptions.ConfigurationParsingException;
import org.xml.sax.SAXException;

public class PicketBoxConfiguration {
    public void load(String configFileName) throws ConfigurationParsingException {
        if (configFileName == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("configFileName");
        }
        InputStream configStream = null;
        try {
            configStream = this.loadStream(configFileName);
            this.load(configStream);
        }
        finally {
            this.safeClose(configStream);
        }
    }

    public void load(InputStream configStream) throws ConfigurationParsingException {
        if (configStream == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("configStream");
        }
        StaxBasedConfigParser parser = new StaxBasedConfigParser();
        try {
            parser.parse(configStream);
        }
        catch (XMLStreamException e) {
            throw new ConfigurationParsingException(e);
        }
        catch (SAXException s) {
            throw new ConfigurationParsingException(s);
        }
        catch (IOException i) {
            throw new ConfigurationParsingException(i);
        }
    }

    private InputStream loadStream(String configFileName) {
        InputStream configStream = null;
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            configStream = tcl.getResourceAsStream(configFileName);
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.errorLoadingConfigFile(configFileName, (Throwable)e);
        }
        try {
            if (configStream == null) {
                configStream = SecurityActions.getClassLoader(this.getClass()).getResourceAsStream(configFileName);
            }
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.errorLoadingConfigFile(configFileName, (Throwable)e);
        }
        try {
            if (configStream == null) {
                URL url = new URL(configFileName);
                configStream = url.openStream();
            }
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.errorLoadingConfigFile(configFileName, (Throwable)e);
        }
        return configStream;
    }

    private void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

