/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.factories;

import java.net.URL;
import javax.security.auth.login.Configuration;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.config.ApplicationPolicyRegistration;
import org.jboss.security.config.StandaloneConfiguration;
import org.jboss.security.mapping.MappingManager;
import org.picketbox.factories.SecurityActions;
import org.picketbox.plugins.PicketBoxSecurityManagement;

public class SecurityFactory {
    private static ISecurityManagement securityManagement = new PicketBoxSecurityManagement();
    private static Configuration parentConfiguration = null;
    private static String AUTH_CONF_FILE = "auth.conf";
    private static String AUTH_CONF_SYSPROP = "java.security.auth.login.config";
    private static StandaloneConfiguration standaloneConfiguration;

    public static AuthenticationManager getAuthenticationManager(String securityDomain) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityFactory.class.getName() + ".getAuthenticationManager"));
        }
        SecurityFactory.validate();
        return securityManagement.getAuthenticationManager(securityDomain);
    }

    public static AuthorizationManager getAuthorizationManager(String securityDomain) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityFactory.class.getName() + ".getAuthorizationManager"));
        }
        SecurityFactory.validate();
        return securityManagement.getAuthorizationManager(securityDomain);
    }

    public static AuditManager getAuditManager(String securityDomain) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityFactory.class.getName() + ".getAuditManager"));
        }
        SecurityFactory.validate();
        return securityManagement.getAuditManager(securityDomain);
    }

    public static MappingManager getMappingManager(String securityDomain) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityFactory.class.getName() + ".getMappingManager"));
        }
        SecurityFactory.validate();
        return securityManagement.getMappingManager(securityDomain);
    }

    public static ISecurityManagement getSecurityManagement() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityFactory.class.getName() + ".getSecurityManagement"));
        }
        return securityManagement;
    }

    public static void setSecurityManagement(ISecurityManagement iSecurityManagement) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityFactory.class.getName() + ".setSecurityManagement"));
        }
        securityManagement = iSecurityManagement;
    }

    public static void prepare() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityFactory.class.getName() + ".prepare"));
        }
        if (!(Configuration.getConfiguration() instanceof ApplicationPolicyRegistration)) {
            standaloneConfiguration.setParentConfig(parentConfiguration);
            Configuration.setConfiguration((Configuration)standaloneConfiguration);
        }
    }

    public static SecurityContext establishSecurityContext(String securityDomainName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityFactory.class.getName() + ".establishSecurityContext"));
        }
        SecurityContext securityContext = null;
        try {
            securityContext = SecurityContextFactory.createSecurityContext((String)securityDomainName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SecurityActions.setSecurityContext(securityContext);
        return securityContext;
    }

    public static void release() {
        Configuration config;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityFactory.class.getName() + ".release"));
        }
        if ((config = Configuration.getConfiguration()) == standaloneConfiguration) {
            Configuration.setConfiguration(parentConfiguration);
        }
    }

    private static void validate() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(SecurityFactory.class.getName() + ".validate"));
        }
        assert (securityManagement != null);
    }

    static {
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            if (tcl == null) {
                throw PicketBoxMessages.MESSAGES.invalidThreadContextClassLoader();
            }
            URL configLocation = tcl.getResource(AUTH_CONF_FILE);
            if (SecurityActions.getSystemProperty(AUTH_CONF_SYSPROP, null) == null) {
                if (configLocation == null) {
                    throw PicketBoxMessages.MESSAGES.invalidNullLoginConfig();
                }
                SecurityActions.setSystemProperty(AUTH_CONF_SYSPROP, configLocation.toExternalForm());
            }
            parentConfiguration = Configuration.getConfiguration();
        }
        catch (Exception e) {
            throw PicketBoxMessages.MESSAGES.unableToInitSecurityFactory((Throwable)e);
        }
        standaloneConfiguration = StandaloneConfiguration.getInstance();
    }
}

