/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl;

import org.jboss.security.acl.BasicACLPermission;
import org.jboss.security.acl.BitMaskPermission;

public class CompositeACLPermission
implements BitMaskPermission {
    private int mask = 0;

    public CompositeACLPermission(int mask) {
        this.mask = mask;
    }

    public CompositeACLPermission(BasicACLPermission ... permissions) {
        BasicACLPermission[] basicACLPermissionArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            BasicACLPermission basicPermission = basicACLPermissionArray[n2];
            this.mask |= basicPermission.getMaskValue();
            ++n2;
        }
    }

    public int getMaskValue() {
        return this.mask;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BitMaskPermission) {
            return this.mask == ((BitMaskPermission)obj).getMaskValue();
        }
        return false;
    }

    public int hashCode() {
        return this.mask;
    }

    public String toString() {
        if (this.mask == 0) {
            return "NO PERMISSION";
        }
        StringBuffer buffer = new StringBuffer();
        BasicACLPermission[] basicACLPermissionArray = BasicACLPermission.values();
        int n = basicACLPermissionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicACLPermission permission = basicACLPermissionArray[n2];
            if ((permission.getMaskValue() & this.mask) != 0) {
                buffer.append(String.valueOf(permission.toString()) + ",");
            }
            ++n2;
        }
        return buffer.substring(0, buffer.lastIndexOf(","));
    }

    public String toBinaryString() {
        return Integer.toBinaryString(this.mask);
    }
}

