/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.message.config.JBossAuthConfigProvider;
import org.jboss.security.auth.message.config.SecurityActions;

public class JBossAuthConfigFactory
extends AuthConfigFactory {
    private ConcurrentMap<String, AuthConfigProvider> keyToAuthConfigProviderMap = new ConcurrentHashMap<String, AuthConfigProvider>();
    private ConcurrentMap<String, RegistrationListener> keyToRegistrationListenerMap = new ConcurrentHashMap<String, RegistrationListener>();
    private ConcurrentMap<String, AuthConfigFactory.RegistrationContext> keyToRegistrationContextMap = new ConcurrentHashMap<String, AuthConfigFactory.RegistrationContext>();

    public JBossAuthConfigFactory() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        JBossAuthConfigProvider provider = new JBossAuthConfigProvider(props, null);
        this.registerConfigProvider(provider, "HTTP", null, "Default Provider");
        this.registerConfigProvider(provider, "HttpServlet", null, "Default Provider");
    }

    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        if (listener == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("listener");
        }
        String[] arr = new String[]{};
        String input = layer + appContext;
        String allLayer = "null" + appContext;
        String allContext = layer + "null";
        String general = "nullnull";
        RegistrationListener origListener = null;
        String key = null;
        for (int i = 0; i < 4 && origListener == null; ++i) {
            if (i == 0) {
                key = input;
            }
            if (i == 1) {
                key = allLayer;
            }
            if (i == 2) {
                key = allContext;
            }
            if (i == 3) {
                key = general;
            }
            origListener = (RegistrationListener)this.keyToRegistrationListenerMap.get(key);
        }
        if (origListener == listener) {
            this.keyToRegistrationListenerMap.remove(key, listener);
        }
        return arr;
    }

    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        String input = layer + appContext;
        String allLayer = "null" + appContext;
        String allContext = layer + "null";
        String general = "nullnull";
        AuthConfigProvider acp = null;
        String key = null;
        for (int i = 0; i < 4 && acp == null; ++i) {
            if (i == 0) {
                key = input;
            }
            if (i == 1) {
                key = allLayer;
            }
            if (i == 2) {
                key = allContext;
            }
            if (i == 3) {
                key = general;
            }
            acp = (AuthConfigProvider)this.keyToAuthConfigProviderMap.get(key);
        }
        if (listener != null) {
            this.keyToRegistrationListenerMap.put(input, listener);
        }
        return acp;
    }

    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        return (AuthConfigFactory.RegistrationContext)this.keyToRegistrationContextMap.get(registrationID);
    }

    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        ArrayList al = new ArrayList();
        if (provider == null) {
            al.addAll(this.keyToAuthConfigProviderMap.keySet());
        } else {
            for (Map.Entry entry : this.keyToAuthConfigProviderMap.entrySet()) {
                if (!((AuthConfigProvider)entry.getValue()).equals(provider)) continue;
                al.add(entry.getKey());
            }
        }
        String[] sarr = new String[al.size()];
        al.toArray(sarr);
        return sarr;
    }

    public void refresh() {
    }

    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        String registrationID;
        AuthConfigProvider oldProvider;
        AuthConfigProvider acp = null;
        if (className != null) {
            try {
                Class<?> provClass = SecurityActions.getContextClassLoader().loadClass(className);
                Constructor<?> ctr = provClass.getConstructor(Map.class, AuthConfigFactory.class);
                acp = (AuthConfigProvider)ctr.newInstance(properties, null);
            }
            catch (Exception e) {
                throw PicketBoxMessages.MESSAGES.failedToRegisterAuthConfigProvider(className, (Throwable)e);
            }
        }
        if ((oldProvider = (AuthConfigProvider)this.keyToAuthConfigProviderMap.put(registrationID = layer + appContext, acp)) != null) {
            JBossRegistrationContext context = (JBossRegistrationContext)this.keyToRegistrationContextMap.get(registrationID);
            context.setDescription(description);
            context.setIsPersistent(true);
            RegistrationListener listener = (RegistrationListener)this.keyToRegistrationListenerMap.get(registrationID);
            if (listener != null) {
                listener.notify(layer, appContext);
            }
        } else {
            JBossRegistrationContext context = new JBossRegistrationContext(layer, appContext, description, true);
            this.keyToRegistrationContextMap.put(registrationID, context);
        }
        return registrationID;
    }

    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        String registrationID = layer + appContext;
        AuthConfigProvider oldProvider = this.keyToAuthConfigProviderMap.put(registrationID, provider);
        if (oldProvider != null) {
            JBossRegistrationContext context = (JBossRegistrationContext)this.keyToRegistrationContextMap.get(registrationID);
            context.setDescription(description);
            context.setIsPersistent(false);
            RegistrationListener listener = (RegistrationListener)this.keyToRegistrationListenerMap.get(registrationID);
            if (listener != null) {
                listener.notify(layer, appContext);
            }
        } else {
            JBossRegistrationContext context = new JBossRegistrationContext(layer, appContext, description, false);
            this.keyToRegistrationContextMap.put(registrationID, context);
        }
        return registrationID;
    }

    public boolean removeRegistration(String registrationID) {
        boolean removed;
        if (registrationID == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("registrationID");
        }
        RegistrationListener listener = (RegistrationListener)this.keyToRegistrationListenerMap.get(registrationID);
        AuthConfigFactory.RegistrationContext rc = (AuthConfigFactory.RegistrationContext)this.keyToRegistrationContextMap.get(registrationID);
        boolean bl = removed = this.keyToAuthConfigProviderMap.remove(registrationID) != null;
        if (removed && listener != null) {
            listener.notify(rc.getMessageLayer(), rc.getAppContext());
        }
        this.keyToRegistrationContextMap.remove(registrationID);
        return removed;
    }

    static class JBossRegistrationContext
    implements AuthConfigFactory.RegistrationContext {
        private String messageLayer;
        private String appContext;
        private String description;
        private boolean isPersistent;

        JBossRegistrationContext(String layer, String appContext, String description, boolean isPersistent) {
            this.messageLayer = layer;
            this.appContext = appContext;
            this.description = description;
            this.isPersistent = isPersistent;
        }

        public String getAppContext() {
            return this.appContext;
        }

        public void setAppContext(String appContext) {
            this.appContext = appContext;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getMessageLayer() {
            return this.messageLayer;
        }

        public void setMessageLayer(String messageLayer) {
            this.messageLayer = messageLayer;
        }

        public boolean isPersistent() {
            return this.isPersistent;
        }

        public void setIsPersistent(boolean isPersistent) {
            this.isPersistent = isPersistent;
        }
    }
}

