/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;

public class DeploymentRolesMappingProvider
implements MappingProvider<RoleGroup> {
    private MappingResult<RoleGroup> result;

    public void init(Map<String, Object> options) {
    }

    public void setMappingResult(MappingResult<RoleGroup> res) {
        this.result = res;
    }

    public void performMapping(Map<String, Object> contextMap, RoleGroup mappedObject) {
        if (contextMap == null || contextMap.isEmpty()) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextMap");
        }
        Principal principal = (Principal)contextMap.get("Principal");
        Map principalRolesMap = (Map)contextMap.get("deploymentPrincipalRolesMap");
        Set subjectPrincipals = (Set)contextMap.get("PrincipalsSet");
        PicketBoxLogger.LOGGER.debugMappingProviderOptions(principal, principalRolesMap, subjectPrincipals);
        if (principalRolesMap == null || principalRolesMap.isEmpty()) {
            this.result.setMappedObject((Object)mappedObject);
            return;
        }
        if (principal != null) {
            mappedObject = this.mapGroup(principal, principalRolesMap, mappedObject);
        }
        if (subjectPrincipals != null) {
            for (Principal p : subjectPrincipals) {
                if (p instanceof Group) continue;
                mappedObject = this.mapGroup(p, principalRolesMap, mappedObject);
            }
        }
        this.result.setMappedObject((Object)mappedObject);
    }

    public boolean supports(Class<?> p) {
        return RoleGroup.class.isAssignableFrom(p);
    }

    private RoleGroup mapGroup(Principal principal, Map<String, Set<String>> principalRolesMap, RoleGroup mappedObject) {
        Set<String> roleset = principalRolesMap.get(principal.getName());
        if (roleset != null) {
            SimpleRoleGroup newRoles = new SimpleRoleGroup("Roles");
            if (roleset != null) {
                for (String r : roleset) {
                    newRoles.addRole(new SimpleRole(r));
                }
            }
            mappedObject.clearRoles();
            mappedObject.addAll(newRoles.getRoles());
        }
        return mappedObject;
    }
}

