/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.auth.spi.Util;
import org.jboss.security.plugins.TransactionManagerLocator;

public class DatabaseServerLoginModule
extends UsernamePasswordLoginModule {
    private static final String DS_JNDI_NAME = "dsJndiName";
    private static final String ROLES_QUERY = "rolesQuery";
    private static final String SUSPEND_RESUME = "suspendResume";
    private static final String PRINCIPALS_QUERY = "principalsQuery";
    private static final String TRANSACTION_MANAGER_JNDI_NAME = "transactionManagerJndiName";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"dsJndiName", "rolesQuery", "suspendResume", "principalsQuery", "transactionManagerJndiName"};
    protected String dsJndiName;
    protected String principalsQuery = "select Password from Principals where PrincipalID=?";
    protected String rolesQuery;
    protected boolean suspendResume = true;
    protected String txManagerJndiName = "java:/TransactionManager";
    protected TransactionManager tm = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String jname;
        Object tmp;
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get(DS_JNDI_NAME);
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/DefaultDS";
        }
        if ((tmp = options.get(PRINCIPALS_QUERY)) != null) {
            this.principalsQuery = tmp.toString();
        }
        if ((tmp = options.get(ROLES_QUERY)) != null) {
            this.rolesQuery = tmp.toString();
        }
        if ((tmp = options.get(SUSPEND_RESUME)) != null) {
            this.suspendResume = Boolean.valueOf(tmp.toString());
        }
        if ((jname = (String)options.get(TRANSACTION_MANAGER_JNDI_NAME)) != null) {
            this.txManagerJndiName = jname;
        }
        PicketBoxLogger.LOGGER.traceDBCertLoginModuleOptions(this.dsJndiName, this.principalsQuery, this.rolesQuery, this.suspendResume);
        try {
            if (this.suspendResume) {
                this.tm = this.getTransactionManager();
            }
        }
        catch (NamingException e) {
            throw PicketBoxMessages.MESSAGES.failedToGetTransactionManager((Throwable)e);
        }
    }

    @Override
    protected String getUsersPassword() throws LoginException {
        String username = this.getUsername();
        String password = null;
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        Transaction tx = null;
        if (this.suspendResume) {
            try {
                if (this.tm == null) {
                    throw PicketBoxMessages.MESSAGES.invalidNullTransactionManager();
                }
                tx = this.tm.suspend();
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            conn = ds.getConnection();
            PicketBoxLogger.LOGGER.traceExecuteQuery(this.principalsQuery, username);
            ps = conn.prepareStatement(this.principalsQuery);
            ps.setString(1, username);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw PicketBoxMessages.MESSAGES.noMatchingUsernameFoundInPrincipals();
            }
            password = rs.getString(1);
            password = this.convertRawPassword(password);
        }
        catch (NamingException ex) {
            LoginException le = new LoginException(PicketBoxMessages.MESSAGES.failedToLookupDataSourceMessage(this.dsJndiName));
            le.initCause(ex);
            throw le;
        }
        catch (SQLException ex) {
            LoginException le = new LoginException(PicketBoxMessages.MESSAGES.failedToProcessQueryMessage());
            le.initCause(ex);
            throw le;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.suspendResume) {
                try {
                    this.tm.resume(tx);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return password;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        if (this.rolesQuery != null) {
            String username = this.getUsername();
            PicketBoxLogger.LOGGER.traceExecuteQuery(this.rolesQuery, username);
            Group[] roleSets = Util.getRoleSets(username, this.dsJndiName, this.txManagerJndiName, this.rolesQuery, this, this.suspendResume);
            return roleSets;
        }
        return new Group[0];
    }

    protected String convertRawPassword(String rawPassword) {
        return rawPassword;
    }

    protected TransactionManager getTransactionManager() throws NamingException {
        TransactionManagerLocator tml = new TransactionManagerLocator();
        return tml.getTM(this.txManagerJndiName);
    }
}

