/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.BaseSecurityInfo;
import org.jboss.security.config.Element;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.config.parser.AclConfigParser;
import org.jboss.security.config.parser.AuditConfigParser;
import org.jboss.security.config.parser.AuthenticationConfigParser;
import org.jboss.security.config.parser.AuthenticationJASPIConfigParser;
import org.jboss.security.config.parser.AuthorizationConfigParser;
import org.jboss.security.config.parser.IdentityTrustConfigParser;
import org.jboss.security.config.parser.MappingConfigParser;
import org.jboss.security.config.parser.StaxParserUtil;
import org.jboss.security.mapping.MappingType;
import org.jboss.security.mapping.config.MappingModuleEntry;

public class ApplicationPolicyParser
implements XMLStreamConstants {
    public List<ApplicationPolicy> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        ArrayList<ApplicationPolicy> policies = new ArrayList<ApplicationPolicy>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            int eventType = xmlEvent.getEventType();
            switch (eventType) {
                case 1: {
                    StartElement appPolicyElement = (StartElement)xmlEvent;
                    String elementName = StaxParserUtil.getStartElementName(appPolicyElement);
                    if (!"application-policy".equals(elementName)) {
                        throw StaxParserUtil.unexpectedElement(elementName, xmlEvent);
                    }
                    Iterator<javax.xml.stream.events.Attribute> attrs = appPolicyElement.getAttributes();
                    String extendsName = null;
                    String appPolicyName = null;
                    while (attrs.hasNext()) {
                        javax.xml.stream.events.Attribute attribute = attrs.next();
                        QName attributeName = attribute.getName();
                        String attributeValue = StaxParserUtil.getAttributeValue(attribute);
                        if ("name".equals(attributeName.getLocalPart())) {
                            appPolicyName = attributeValue;
                            continue;
                        }
                        if (!"extends".equals(attributeName.getLocalPart())) continue;
                        extendsName = attributeValue;
                    }
                    ApplicationPolicy applicationPolicy = new ApplicationPolicy(appPolicyName);
                    if (extendsName != null) {
                        applicationPolicy.setBaseApplicationPolicyName(extendsName);
                    }
                    this.route(xmlEventReader, applicationPolicy);
                    policies.add(applicationPolicy);
                }
            }
        }
        return policies;
    }

    private void route(XMLEventReader xmlEventReader, ApplicationPolicy appPolicy) throws XMLStreamException {
        String elementName;
        XMLEvent xmlEvent;
        block0: while (true) {
            Object mappingInfo;
            BaseSecurityInfo authInfo;
            Collection<Object> entries;
            XMLStreamConstants parser;
            if ((xmlEvent = xmlEventReader.peek()) == null) {
                return;
            }
            StartElement startElement = xmlEvent.asStartElement();
            elementName = StaxParserUtil.getStartElementName(startElement);
            if ("authentication".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new AuthenticationConfigParser();
                entries = ((AuthenticationConfigParser)parser).parse(xmlEventReader);
                authInfo = new AuthenticationInfo();
                ((AuthenticationInfo)authInfo).setAppConfigurationEntry(new ArrayList<AppConfigurationEntry>(entries));
                appPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authInfo);
                continue;
            }
            if ("authentication-jaspi".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new AuthenticationJASPIConfigParser();
                JASPIAuthenticationInfo authInfo2 = ((AuthenticationJASPIConfigParser)parser).parse(xmlEventReader);
                appPolicy.setAuthenticationInfo(authInfo2);
                continue;
            }
            if ("authorization".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new AuthorizationConfigParser();
                entries = ((AuthorizationConfigParser)parser).parse(xmlEventReader);
                authInfo = new AuthorizationInfo(appPolicy.getName());
                authInfo.add(new ArrayList<AppConfigurationEntry>(entries));
                appPolicy.setAuthorizationInfo((AuthorizationInfo)authInfo);
                continue;
            }
            if ("acl".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new AclConfigParser();
                entries = ((AclConfigParser)parser).parse(xmlEventReader);
                ACLInfo aclInfo = new ACLInfo(appPolicy.getName());
                aclInfo.add(new ArrayList<Object>(entries));
                appPolicy.setAclInfo(aclInfo);
                continue;
            }
            if ("rolemapping".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new MappingConfigParser();
                entries = ((MappingConfigParser)parser).parse(xmlEventReader);
                mappingInfo = new MappingInfo(appPolicy.getName());
                ((BaseSecurityInfo)mappingInfo).add(entries);
                appPolicy.setMappingInfo(MappingType.ROLE.toString(), (MappingInfo)mappingInfo);
                continue;
            }
            if ("mapping".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new MappingConfigParser();
                entries = ((MappingConfigParser)parser).parse(xmlEventReader);
                mappingInfo = entries.iterator();
                while (true) {
                    if (!mappingInfo.hasNext()) continue block0;
                    MappingModuleEntry entry = (MappingModuleEntry)mappingInfo.next();
                    MappingInfo mappingInfo2 = new MappingInfo(appPolicy.getName());
                    mappingInfo2.add(entry);
                    String moduleType = entry.getMappingModuleType();
                    appPolicy.setMappingInfo(moduleType, mappingInfo2);
                }
            }
            if ("audit".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new AuditConfigParser();
                entries = ((AuditConfigParser)parser).parse(xmlEventReader);
                authInfo = new AuditInfo(appPolicy.getName());
                authInfo.add(entries);
                appPolicy.setAuditInfo((AuditInfo)authInfo);
                continue;
            }
            if (!"identity-trust".equals(elementName)) break;
            xmlEvent = xmlEventReader.nextEvent();
            parser = new IdentityTrustConfigParser();
            entries = ((IdentityTrustConfigParser)parser).parse(xmlEventReader);
            authInfo = new IdentityTrustInfo(appPolicy.getName());
            authInfo.add(entries);
            appPolicy.setIdentityTrustInfo((IdentityTrustInfo)authInfo);
        }
        if (!"application-policy".equals(elementName)) {
            throw StaxParserUtil.unexpectedElement(elementName, xmlEvent);
        }
    }

    public List<ApplicationPolicy> parse(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<ApplicationPolicy> policies = null;
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element.equals((Object)Element.APPLICATION_POLICY) || element.equals((Object)Element.SECURITY_DOMAIN)) {
                int count = reader.getAttributeCount();
                if (count == 0) {
                    throw StaxParserUtil.missingRequired(reader, Collections.singleton(Attribute.NAME));
                }
                String name = null;
                String extendsName = null;
                block5: for (int i = 0; i < count; ++i) {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            name = value;
                            continue block5;
                        }
                        case EXTENDS: {
                            extendsName = value;
                            continue block5;
                        }
                        default: {
                            throw StaxParserUtil.unexpectedAttribute(reader, i);
                        }
                    }
                }
                if (name == null) {
                    throw StaxParserUtil.missingRequired(reader, Collections.singleton(Attribute.NAME));
                }
                ApplicationPolicy applicationPolicy = new ApplicationPolicy(name);
                if (extendsName != null) {
                    applicationPolicy.setBaseApplicationPolicyName(extendsName);
                }
                this.route(reader, applicationPolicy);
                if (policies == null) {
                    policies = new ArrayList<ApplicationPolicy>();
                }
                policies.add(applicationPolicy);
                continue;
            }
            throw StaxParserUtil.unexpectedElement(reader);
        }
        return policies;
    }

    private void route(XMLStreamReader reader, ApplicationPolicy appPolicy) throws XMLStreamException {
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACL: {
                    XMLStreamConstants parser = new AclConfigParser();
                    Collection<Object> entries = ((AclConfigParser)parser).parse(reader);
                    ACLInfo aclInfo = new ACLInfo(appPolicy.getName());
                    aclInfo.add(new ArrayList<Object>(entries));
                    appPolicy.setAclInfo(aclInfo);
                    break;
                }
                case AUDIT: {
                    XMLStreamConstants parser = new AuditConfigParser();
                    Collection<Object> entries = ((AuditConfigParser)parser).parse(reader);
                    Object authInfo = new AuditInfo(appPolicy.getName());
                    ((BaseSecurityInfo)authInfo).add(entries);
                    appPolicy.setAuditInfo((AuditInfo)authInfo);
                    break;
                }
                case AUTHENTICATION: {
                    XMLStreamConstants parser = new AuthenticationConfigParser();
                    Collection<Object> entries = ((AuthenticationConfigParser)parser).parse(reader);
                    Object authInfo = new AuthenticationInfo(appPolicy.getName());
                    ((AuthenticationInfo)authInfo).setAppConfigurationEntry(new ArrayList<Object>(entries));
                    appPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authInfo);
                    break;
                }
                case AUTHENTICATION_JASPI: {
                    XMLStreamConstants parser = new AuthenticationJASPIConfigParser();
                    JASPIAuthenticationInfo authInfo = ((AuthenticationJASPIConfigParser)parser).parse(reader);
                    appPolicy.setAuthenticationInfo(authInfo);
                    break;
                }
                case AUTHORIZATION: {
                    XMLStreamConstants parser = new AuthorizationConfigParser();
                    Collection<Object> entries = ((AuthorizationConfigParser)parser).parse(reader);
                    Object authInfo = new AuthorizationInfo(appPolicy.getName());
                    ((BaseSecurityInfo)authInfo).add(new ArrayList<Object>(entries));
                    appPolicy.setAuthorizationInfo((AuthorizationInfo)authInfo);
                    break;
                }
                case IDENTITY_TRUST: {
                    XMLStreamConstants parser = new IdentityTrustConfigParser();
                    Collection<Object> entries = ((IdentityTrustConfigParser)parser).parse(reader);
                    Object authInfo = new IdentityTrustInfo(appPolicy.getName());
                    ((BaseSecurityInfo)authInfo).add(entries);
                    appPolicy.setIdentityTrustInfo((IdentityTrustInfo)authInfo);
                    break;
                }
                case MAPPING: {
                    XMLStreamConstants parser = new MappingConfigParser();
                    Collection<Object> entries = ((MappingConfigParser)parser).parse(reader);
                    for (MappingModuleEntry mappingModuleEntry : entries) {
                        MappingInfo mappingInfo = new MappingInfo(appPolicy.getName());
                        mappingInfo.add(mappingModuleEntry);
                        String moduleType = mappingModuleEntry.getMappingModuleType();
                        appPolicy.setMappingInfo(moduleType, mappingInfo);
                    }
                    continue block10;
                }
                case ROLE_MAPPING: {
                    XMLStreamConstants parser = new MappingConfigParser();
                    Collection<Object> entries = ((MappingConfigParser)parser).parse(reader);
                    MappingInfo mappingInfo = new MappingInfo(appPolicy.getName());
                    mappingInfo.add(entries);
                    appPolicy.setMappingInfo(MappingType.ROLE.toString(), mappingInfo);
                    break;
                }
                default: {
                    throw StaxParserUtil.unexpectedElement(reader);
                }
            }
        }
    }
}

