/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.audit;

import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.SecurityUtil;
import org.jboss.security.audit.AuditContext;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.audit.AuditProvider;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.audit.providers.LogAuditProvider;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.jboss.security.plugins.ClassLoaderLocatorFactory;
import org.jboss.security.plugins.audit.JBossAuditContext;
import org.jboss.security.plugins.audit.SecurityActions;

public class JBossAuditManager
implements AuditManager {
    private static ConcurrentMap<String, AuditContext> contexts = new ConcurrentHashMap<String, AuditContext>();
    private static AuditContext defaultContext = null;
    private String securityDomain;

    public JBossAuditManager(String secDomain) {
        this.securityDomain = SecurityUtil.unprefixSecurityDomain(secDomain);
    }

    public AuditContext getAuditContext() throws PrivilegedActionException {
        ClassLoader moduleCL = null;
        AuditContext ac = (AuditContext)contexts.get(this.securityDomain);
        if (ac == null) {
            AuditInfo ai;
            ac = new JBossAuditContext(this.securityDomain);
            ApplicationPolicy ap = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
            if (ap != null && (ai = ap.getAuditInfo()) != null) {
                ClassLoaderLocator cll;
                String jbossModuleName = ai.getJBossModuleName();
                if (jbossModuleName != null && (cll = ClassLoaderLocatorFactory.get()) != null) {
                    moduleCL = cll.get(jbossModuleName);
                }
                ac = this.instantiate(moduleCL, ai);
            }
        }
        if (ac == null) {
            PicketBoxLogger.LOGGER.traceNoAuditContextFoundForDomain(this.securityDomain);
            ac = defaultContext;
        }
        return ac;
    }

    public static AuditContext getAuditContext(String securityDomain) {
        AuditContext ac;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(JBossAuditManager.class.getName() + ".getAuditContext"));
        }
        if ((ac = (AuditContext)contexts.get(securityDomain)) == null) {
            ac = defaultContext;
        }
        return ac;
    }

    public static void addAuditContext(String securityDomain, AuditContext ac) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(JBossAuditManager.class.getName() + ".addAuditContext"));
        }
        contexts.put(securityDomain, ac);
    }

    public void audit(AuditEvent ae) {
        AuditContext ac = null;
        try {
            ac = this.getAuditContext();
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
        ac.audit(ae);
        if (ac != defaultContext) {
            defaultContext.audit(ae);
        }
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    private AuditContext instantiate(ClassLoader cl, AuditInfo ai) {
        JBossAuditContext ac = new JBossAuditContext(this.securityDomain);
        AuditProviderEntry[] apeArr = ai.getAuditProviderEntry();
        List<AuditProviderEntry> list = Arrays.asList(apeArr);
        for (AuditProviderEntry ape : list) {
            String pname = ape.getName();
            try {
                Class<?> clazz = SecurityActions.loadClass(cl, pname);
                ac.addProvider((AuditProvider)clazz.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ac;
    }

    static {
        defaultContext = new JBossAuditContext("Default_Context");
        defaultContext.addProvider((AuditProvider)new LogAuditProvider());
    }
}

