/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.xacml.core.JBossPDP;
import org.jboss.security.xacml.factories.PolicyFactory;
import org.jboss.security.xacml.interfaces.XACMLPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPolicyRegistration
implements PolicyRegistration,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Set<XACMLPolicy>> contextIdToXACMLPolicy = new HashMap<String, Set<XACMLPolicy>>();
    private final Map<String, JBossPDP> contextIDToJBossPDP = new HashMap<String, JBossPDP>();

    public void deRegisterPolicy(String contextID, String type) {
        if ("XACML".equalsIgnoreCase(type)) {
            this.contextIdToXACMLPolicy.remove(contextID);
            PicketBoxLogger.LOGGER.traceDeregisterPolicy(contextID, type);
        }
    }

    public <T> T getPolicy(String contextID, String type, Map<String, Object> contextMap) {
        if ("XACML".equalsIgnoreCase(type)) {
            String pdp;
            if (contextMap != null && (pdp = (String)contextMap.get("PDP")) != null) {
                return (T)this.contextIDToJBossPDP.get(contextID);
            }
            return (T)this.contextIdToXACMLPolicy.get(contextID);
        }
        throw PicketBoxMessages.MESSAGES.invalidPolicyRegistrationType(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPolicy(String contextID, String type, URL location) {
        InputStream is = null;
        try {
            if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
                PicketBoxLogger.LOGGER.traceRegisterPolicy(contextID, type, location != null ? location.getPath() : null);
            }
            is = location.openStream();
            this.registerPolicy(contextID, type, is);
            this.safeClose(is);
        }
        catch (Exception e) {
            try {
                PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)e);
                this.safeClose(is);
            }
            catch (Throwable throwable) {
                this.safeClose(is);
                throw throwable;
            }
        }
    }

    public void registerPolicy(String contextID, String type, InputStream stream) {
        if ("XACML".equalsIgnoreCase(type)) {
            try {
                XACMLPolicy policy = PolicyFactory.createPolicy((InputStream)stream);
                Set<XACMLPolicy> policySet = this.contextIdToXACMLPolicy.get(contextID);
                if (policySet == null) {
                    policySet = new HashSet<XACMLPolicy>();
                }
                policySet.add(policy);
                this.contextIdToXACMLPolicy.put(contextID, policySet);
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)e);
            }
        }
    }

    public <P> void registerPolicyConfig(String contextId, String type, P objectModel) {
        if ("XACML".equalsIgnoreCase(type)) {
            if (!(objectModel instanceof JAXBElement)) {
                throw PicketBoxMessages.MESSAGES.invalidType(JAXBElement.class.getName());
            }
            try {
                JAXBElement jaxbModel = (JAXBElement)objectModel;
                JBossPDP pdp = new JBossPDP(jaxbModel);
                this.contextIDToJBossPDP.put(contextId, pdp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void registerPolicyConfigFile(String contextId, String type, InputStream stream) {
        if ("XACML".equalsIgnoreCase(type)) {
            try {
                JBossPDP pdp = new JBossPDP(stream);
                this.contextIDToJBossPDP.put(contextId, pdp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

