/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.certs;

import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.SimplePrincipal;

public class SubjectCNMapping
implements CertificatePrincipal {
    public Principal toPrincipal(X509Certificate[] certs) {
        Principal cn = null;
        LdapName dn = null;
        Principal subject = certs[0].getSubjectDN();
        try {
            dn = new LdapName(subject.getName());
            for (Rdn rdn : dn.getRdns()) {
                if (rdn.getType().compareToIgnoreCase("cn") != 0) continue;
                cn = new SimplePrincipal(rdn.getValue().toString());
            }
        }
        catch (InvalidNameException e) {
            // empty catch block
        }
        if (cn == null) {
            cn = subject;
        }
        return cn;
    }

    public Principal toPrinicipal(X509Certificate[] certs) {
        return this.toPrincipal(certs);
    }
}

