/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.role;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.mapping.providers.role.SecurityActions;

public class Util {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadProperties(String propertiesName, Logger log) throws IOException {
        URL url;
        Properties bundle;
        boolean trace;
        block17: {
            trace = log.isTraceEnabled();
            bundle = null;
            ClassLoader loader = SecurityActions.getContextClassLoader();
            url = null;
            if (loader instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)loader;
                url = SecurityActions.findResource(ucl, propertiesName);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("findResource: " + url));
                }
            }
            if (url == null) {
                url = loader.getResource(propertiesName);
            }
            if (url == null) {
                try {
                    url = new URL(propertiesName);
                }
                catch (MalformedURLException mue) {
                    File tmp;
                    if (trace) {
                        log.trace((Object)"Failed to open properties as URL", (Throwable)mue);
                    }
                    if (!(tmp = new File(propertiesName)).exists()) break block17;
                    url = tmp.toURI().toURL();
                }
            }
        }
        if (url == null) {
            String msg = "No properties file " + propertiesName + " found";
            throw new IOException(msg);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Properties file=" + url));
        }
        Properties defaults = new Properties();
        bundle = new Properties(defaults);
        InputStream is = null;
        try {
            is = SecurityActions.openStream(url);
        }
        catch (PrivilegedActionException e) {
            if (trace) {
                log.trace((Object)"Open stream error", (Throwable)e);
            }
            throw new IOException(e.getLocalizedMessage());
        }
        if (is != null) {
            try {
                bundle.load(is);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                Util.safeClose(is);
                throw throwable;
            }
        } else {
            throw new IOException("PB00023: Missing File:Properties file " + propertiesName + " not available");
        }
        Util.safeClose(is);
        if (trace) {
            log.debug((Object)("Loaded properties, keySet=" + bundle.keySet()));
        }
        return bundle;
    }

    static void addRolesToGroup(String username, RoleGroup roleGroup, Properties roles, Logger log) {
        boolean trace = log.isTraceEnabled();
        String[] roleNames = null;
        if (roles.containsKey(username)) {
            String value = roles.getProperty(username);
            if (trace) {
                log.trace((Object)("Adding to RoleGroup: " + value));
            }
            roleNames = Util.parseRoles(value);
        }
        if (roleNames != null) {
            for (int i = 0; i < roleNames.length; ++i) {
                roleGroup.addRole((Role)new SimpleRole(roleNames[i]));
            }
        }
    }

    static String[] parseRoles(String roles) {
        return roles.split(",");
    }

    /*
     * Loose catch block
     */
    static void addRolesToGroup(String username, RoleGroup roleGroup, String dsJndiName, String rolesQuery, Logger log, boolean suspendResume, TransactionManager tm) {
        block39: {
            Exception e3;
            Transaction tx;
            ResultSet rs;
            Statement ps;
            Connection conn;
            boolean trace;
            block35: {
                trace = log.isTraceEnabled();
                conn = null;
                ps = null;
                rs = null;
                if (suspendResume && tm == null) {
                    throw new IllegalStateException("PB00015: Null Value:Transaction Manager is null");
                }
                tx = null;
                if (suspendResume) {
                    try {
                        tx = tm.suspend();
                    }
                    catch (SystemException e2) {
                        throw new RuntimeException(e2);
                    }
                    if (trace) {
                        log.trace((Object)"suspendAnyTransaction");
                    }
                }
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(dsJndiName);
                conn = ds.getConnection();
                if (trace) {
                    log.trace((Object)("Excuting query: " + rolesQuery + ", with username: " + username));
                }
                ps = conn.prepareStatement(rolesQuery);
                try {
                    ps.setString(1, username);
                }
                catch (ArrayIndexOutOfBoundsException ignore) {
                    // empty catch block
                }
                rs = ps.executeQuery();
                if (!rs.next() && trace) {
                    log.trace((Object)"No roles found");
                }
                do {
                    String name = rs.getString(1);
                    roleGroup.addRole((Role)new SimpleRole(name));
                } while (rs.next());
                Object var16_19 = null;
                if (rs == null) break block35;
                try {
                    rs.close();
                }
                catch (SQLException e3) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e3) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!suspendResume) break block39;
            try {
                tm.resume(tx);
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
            if (trace) {
                log.trace((Object)"resumeAnyTransaction");
            }
            break block39;
            {
                catch (NamingException ex) {
                    throw new IllegalArgumentException("PB00019: Processing Failed:Error looking up DataSource from: " + dsJndiName, ex);
                }
                catch (SQLException ex) {
                    throw new IllegalArgumentException("PB00019: Processing Failed:Query failed", ex);
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e3) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e3) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (suspendResume) {
                    try {
                        tm.resume(tx);
                    }
                    catch (Exception e3) {
                        throw new RuntimeException(e3);
                    }
                    if (trace) {
                        log.trace((Object)"resumeAnyTransaction");
                    }
                }
                throw throwable;
            }
        }
    }

    private static void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

