/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.security.auth.login.Configuration;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.logging.Logger;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ApplicationPolicyRegistration;
import org.jboss.security.config.Element;
import org.jboss.security.config.parser.ApplicationPolicyParser;
import org.jboss.security.config.parser.SecurityActions;
import org.jboss.security.config.parser.StaxParserUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StaxBasedConfigParser
implements XMLStreamConstants {
    private static Logger log = Logger.getLogger(StaxBasedConfigParser.class);
    private boolean trace = log.isTraceEnabled();
    private String schemaFile = "schema/security-config_5_0.xsd";

    public void schemaValidate(InputStream configStream) throws SAXException, IOException {
        Validator validator = this.schemaValidator();
        StreamSource xmlSource = new StreamSource(configStream);
        validator.validate(xmlSource);
    }

    public void parse(InputStream configStream) throws XMLStreamException, SAXException, IOException {
        Configuration config = Configuration.getConfiguration();
        if (!(config instanceof ApplicationPolicyRegistration)) {
            throw new IllegalStateException("PB00016: Wrong Type:JAAS Configuration does not support application policy registration");
        }
        ApplicationPolicyRegistration appPolicyRegistration = (ApplicationPolicyRegistration)((Object)config);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xmlEventReader = this.getXMLEventReader(configStream);
        xmlEventReader = xmlInputFactory.createFilteredReader(xmlEventReader, new EventFilter(){

            public boolean accept(XMLEvent xmlEvent) {
                return xmlEvent.isStartElement();
            }
        });
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            int eventType = xmlEvent.getEventType();
            switch (eventType) {
                case 1: {
                    StartElement policyConfigElement = (StartElement)xmlEvent;
                    if (!"policy".equals(StaxParserUtil.getStartElementName(policyConfigElement))) {
                        throw new IllegalArgumentException("PB00019: Processing Failed:<policy> root element expected at " + StaxParserUtil.getLineColumnNumber(xmlEvent.getLocation()));
                    }
                    ApplicationPolicyParser appPolicyParser = new ApplicationPolicyParser();
                    List<ApplicationPolicy> appPolicies = appPolicyParser.parse(xmlEventReader);
                    for (ApplicationPolicy appPolicy : appPolicies) {
                        appPolicyRegistration.addApplicationPolicy(appPolicy.getName(), appPolicy);
                    }
                    break;
                }
            }
        }
    }

    public void parse2(InputStream configStream) throws XMLStreamException {
        Configuration config = Configuration.getConfiguration();
        if (!(config instanceof ApplicationPolicyRegistration)) {
            throw new IllegalStateException("PB00016: Wrong Type:JAAS Configuration does not support application policy registration");
        }
        ApplicationPolicyRegistration appPolicyRegistration = (ApplicationPolicyRegistration)((Object)config);
        XMLStreamReader reader = this.getXMLStreamReader(configStream);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element.equals((Object)Element.POLICY)) {
                ApplicationPolicyParser appPolicyParser = new ApplicationPolicyParser();
                List<ApplicationPolicy> appPolicies = appPolicyParser.parse(reader);
                for (ApplicationPolicy appPolicy : appPolicies) {
                    appPolicyRegistration.addApplicationPolicy(appPolicy.getName(), appPolicy);
                }
            } else {
                throw StaxParserUtil.unexpectedElement(reader);
            }
            if (!reader.isEndElement()) continue;
            break;
        }
    }

    private Validator schemaValidator() {
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            URL schemaURL = tcl.getResource(this.schemaFile);
            if (schemaURL == null) {
                throw new RuntimeException("PB00022: Missing Value:Cannot find schema :" + this.schemaFile);
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schemaGrammar = schemaFactory.newSchema(schemaURL);
            Validator schemaValidator = schemaGrammar.newValidator();
            schemaValidator.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException ex) throws SAXException {
                    this.logException(ex);
                }

                public void fatalError(SAXParseException ex) throws SAXException {
                    this.logException(ex);
                }

                public void warning(SAXParseException ex) throws SAXException {
                    this.logException(ex);
                }

                private void logException(SAXParseException sax) {
                    StringBuilder builder = new StringBuilder();
                    if (StaxBasedConfigParser.this.trace) {
                        builder.append("[").append(sax.getLineNumber()).append(",").append(sax.getColumnNumber()).append("]");
                        builder.append(":").append(sax.getLocalizedMessage());
                        log.trace((Object)builder.toString());
                    }
                }
            });
            return schemaValidator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XMLEventReader getXMLEventReader(InputStream is) {
        XMLInputFactory xmlInputFactory = null;
        XMLEventReader xmlEventReader = null;
        try {
            xmlInputFactory = XMLInputFactory.newInstance();
            xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            xmlEventReader = xmlInputFactory.createXMLEventReader(is);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return xmlEventReader;
    }

    private XMLStreamReader getXMLStreamReader(InputStream is) {
        XMLInputFactory xmlInputFactory = null;
        XMLStreamReader xmlStreamReader = null;
        try {
            xmlInputFactory = XMLInputFactory.newInstance();
            xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            xmlStreamReader = xmlInputFactory.createXMLStreamReader(is);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return xmlStreamReader;
    }
}

