/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.BaseSecurityInfo;
import org.jboss.security.config.Element;
import org.jboss.security.config.parser.AuthenticationConfigParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JASPIAuthenticationInfo
extends BaseAuthenticationInfo {
    List<LoginModuleStackHolder> loginModuleStack = Collections.synchronizedList(new ArrayList());

    public JASPIAuthenticationInfo() {
    }

    public JASPIAuthenticationInfo(String name) {
        super(name);
    }

    @Override
    public void add(LoginModuleStackHolder lmsHolder) {
        this.loginModuleStack.add(lmsHolder);
    }

    @Override
    public void add(AuthModuleEntry ame) {
        this.moduleEntries.add(ame);
    }

    public AuthModuleEntry[] getAuthModuleEntry() {
        AuthModuleEntry[] entries = new AuthModuleEntry[this.moduleEntries.size()];
        this.moduleEntries.toArray(entries);
        return entries;
    }

    public LoginModuleStackHolder getLoginModuleStackHolder(String name) {
        for (LoginModuleStackHolder holder : this.loginModuleStack) {
            if (!holder.getName().equals(name)) continue;
            return holder;
        }
        return null;
    }

    public LoginModuleStackHolder[] getLoginModuleStackHolder() {
        LoginModuleStackHolder[] lmshArr = new LoginModuleStackHolder[this.loginModuleStack.size()];
        this.loginModuleStack.toArray(lmshArr);
        return lmshArr;
    }

    public LoginModuleStackHolder removeLoginModuleStackHolder(String name) {
        Iterator<LoginModuleStackHolder> it = this.loginModuleStack.iterator();
        while (it.hasNext()) {
            LoginModuleStackHolder holder = it.next();
            if (!holder.getName().equals(name)) continue;
            it.remove();
            return holder;
        }
        return null;
    }

    public void copy(JASPIAuthenticationInfo pc) {
        this.loginModuleStack.addAll(pc.loginModuleStack);
        this.moduleEntries.addAll(pc.moduleEntries);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry() {
        if (this.loginModuleStack.size() > 0) {
            return this.loginModuleStack.get(0).getAppConfigurationEntry();
        }
        return new AppConfigurationEntry[0];
    }

    @Override
    public AppConfigurationEntry[] copyAppConfigurationEntry() {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (AppConfigurationEntry entry : this.getAppConfigurationEntry()) {
            entries.add(entry);
        }
        return super.copyAppConfigurationEntry(entries);
    }

    @Override
    protected BaseSecurityInfo<Object> create(String name) {
        return new JASPIAuthenticationInfo(name);
    }

    @Override
    public BaseSecurityInfo<Object> merge(BaseSecurityInfo<Object> bi) {
        if (!(bi instanceof JASPIAuthenticationInfo)) {
            throw new IllegalArgumentException("PB00016: Wrong Type:Base policy does not contain a JASPI authentication configuration");
        }
        JASPIAuthenticationInfo merged = (JASPIAuthenticationInfo)super.merge(bi);
        JASPIAuthenticationInfo parent = (JASPIAuthenticationInfo)bi;
        for (LoginModuleStackHolder holder : parent.getLoginModuleStackHolder()) {
            merged.add(holder);
        }
        for (LoginModuleStackHolder holder : this.getLoginModuleStackHolder()) {
            merged.add(holder);
        }
        return merged;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AuthModuleEntry[]:\n");
        for (int i = 0; i < this.moduleEntries.size(); ++i) {
            AuthModuleEntry entry = (AuthModuleEntry)this.moduleEntries.get(i);
            buffer.append("[" + i + "]");
            buffer.append("\nAuthModule Class: " + entry.getAuthModuleName());
            buffer.append("\nOptions:");
            Map<String, Object> options = entry.getOptions();
            for (Map.Entry<String, Object> optionsEntry : options.entrySet()) {
                buffer.append("name=" + optionsEntry.getKey());
                buffer.append(", value=" + optionsEntry.getValue());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public void writeContent(XMLStreamWriter writer) throws XMLStreamException {
        Object entry;
        int i;
        for (i = 0; i < this.loginModuleStack.size(); ++i) {
            entry = this.loginModuleStack.get(i);
            writer.writeStartElement(Element.LOGIN_MODULE_STACK.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), ((LoginModuleStackHolder)entry).getName());
            for (int j = 0; j < ((LoginModuleStackHolder)entry).getAppConfigurationEntry().length; ++j) {
                writer.writeStartElement(Element.LOGIN_MODULE.getLocalName());
                AppConfigurationEntry ace = ((LoginModuleStackHolder)entry).getAppConfigurationEntry()[j];
                String code = ace.getLoginModuleName();
                if (AuthenticationConfigParser.loginModulesMap.containsValue(code)) {
                    String value = null;
                    Set<Map.Entry<String, String>> entries = AuthenticationConfigParser.loginModulesMap.entrySet();
                    for (Map.Entry<String, String> mapEntry : entries) {
                        if (!mapEntry.getValue().equals(code)) continue;
                        value = mapEntry.getKey();
                        break;
                    }
                    writer.writeAttribute(Attribute.CODE.getLocalName(), value);
                } else {
                    writer.writeAttribute(Attribute.CODE.getLocalName(), code);
                }
                writer.writeAttribute(Attribute.FLAG.getLocalName(), this.valueOf(ace.getControlFlag()));
                Map<String, ?> options = ace.getOptions();
                if (options != null && options.size() > 0) {
                    for (Map.Entry<String, ?> option : options.entrySet()) {
                        writer.writeStartElement(Element.MODULE_OPTION.getLocalName());
                        writer.writeAttribute(Attribute.NAME.getLocalName(), option.getKey());
                        writer.writeAttribute(Attribute.VALUE.getLocalName(), option.getValue().toString());
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        for (i = 0; i < this.moduleEntries.size(); ++i) {
            entry = (AuthModuleEntry)this.moduleEntries.get(i);
            writer.writeStartElement(Element.AUTH_MODULE.getLocalName());
            writer.writeAttribute(Attribute.CODE.getLocalName(), ((AuthModuleEntry)entry).getAuthModuleName());
            writer.writeAttribute(Attribute.FLAG.getLocalName(), ((AuthModuleEntry)entry).getControlFlag().toString().toLowerCase());
            writer.writeAttribute(Attribute.LOGIN_MODULE_STACK_REF.getLocalName(), ((AuthModuleEntry)entry).getLoginModuleStackHolderName());
            Map<String, Object> options = ((AuthModuleEntry)entry).getOptions();
            if (options != null && options.size() > 0) {
                for (Map.Entry<String, Object> option : options.entrySet()) {
                    writer.writeStartElement(Element.MODULE_OPTION.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), option.getKey());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), option.getValue().toString());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private String valueOf(AppConfigurationEntry.LoginModuleControlFlag controlFlag) {
        if (controlFlag.equals(AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL)) {
            return "optional";
        }
        if (controlFlag.equals(AppConfigurationEntry.LoginModuleControlFlag.REQUIRED)) {
            return "required";
        }
        if (controlFlag.equals(AppConfigurationEntry.LoginModuleControlFlag.REQUISITE)) {
            return "requisite";
        }
        return "sufficient";
    }
}

