/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.crypto.digest;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;

public class SHAReverseInterleave
extends MessageDigestSpi {
    private static final int SHA_HASH_LEN = 20;
    private ByteArrayOutputStream evenBytes;
    private ByteArrayOutputStream oddBytes;
    private int count;
    private boolean skipLeadingZeros;
    private MessageDigest sha;

    public SHAReverseInterleave() {
        try {
            this.sha = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException("PB00003: Failed to obtain SHA MessageDigest:");
        }
        this.evenBytes = new ByteArrayOutputStream();
        this.oddBytes = new ByteArrayOutputStream();
        this.engineReset();
    }

    protected int engineGetDigestLength() {
        return 40;
    }

    protected byte[] engineDigest() {
        int i;
        byte[] E = this.evenBytes.toByteArray();
        int length = E.length;
        if (this.count % 2 == 1) {
            --length;
        }
        byte[] tmp = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            tmp[i2] = E[E.length - i2 - 1];
            System.out.println("E[" + i2 + "] = " + tmp[i2]);
        }
        E = tmp;
        byte[] G = this.sha.digest(E);
        byte[] F = this.oddBytes.toByteArray();
        tmp = new byte[F.length];
        for (int i3 = 0; i3 < F.length; ++i3) {
            tmp[i3] = F[F.length - i3 - 1];
            System.out.println("F[" + i3 + "] = " + tmp[i3]);
        }
        F = tmp;
        this.sha.reset();
        byte[] H = this.sha.digest(F);
        length = G.length + H.length;
        byte[] digest = new byte[length];
        for (i = 0; i < G.length; ++i) {
            digest[2 * i] = G[i];
        }
        for (i = 0; i < H.length; ++i) {
            digest[2 * i + 1] = H[i];
        }
        this.engineReset();
        return digest;
    }

    protected void engineReset() {
        this.skipLeadingZeros = true;
        this.count = 0;
        this.evenBytes.reset();
        this.oddBytes.reset();
        this.sha.reset();
    }

    protected void engineUpdate(byte input) {
        if (this.skipLeadingZeros && input == 0) {
            return;
        }
        this.skipLeadingZeros = false;
        if (this.count % 2 == 0) {
            this.evenBytes.write(input);
        } else {
            this.oddBytes.write(input);
        }
        ++this.count;
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        for (int i = offset; i < offset + len; ++i) {
            this.engineUpdate(input[i]);
        }
    }
}

