/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

public class SecurityActions {
    static CallbackHandler getContextCallbackHandler() throws Exception {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextCallbackHandler();
        }
        return PolicyContextActions.PRIVILEGED.getContextCallbackHandler();
    }

    static SecurityContext getCurrentSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static interface PolicyContextActions {
        public static final String CALLBACK_HANDLER_KEY = "org.jboss.security.auth.spi.CallbackHandler";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction<CallbackHandler> exAction = new PrivilegedExceptionAction<CallbackHandler>(){

                @Override
                public CallbackHandler run() throws Exception {
                    return (CallbackHandler)PolicyContext.getContext((String)PolicyContextActions.CALLBACK_HANDLER_KEY);
                }
            };

            public CallbackHandler getContextCallbackHandler() throws PolicyContextException {
                try {
                    return AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)((Object)ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public CallbackHandler getContextCallbackHandler() throws PolicyContextException {
                return (CallbackHandler)PolicyContext.getContext((String)PolicyContextActions.CALLBACK_HANDLER_KEY);
            }
        };

        public CallbackHandler getContextCallbackHandler() throws PolicyContextException;
    }
}

