/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.audit;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static void setContextClassLoader(final ClassLoader tccl) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                Thread.currentThread().setContextClassLoader(tccl);
                return null;
            }
        });
    }

    static ClassLoader getContextClassLoader() throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static Class<?> loadClass(final String name) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    return this.getClass().getClassLoader().loadClass(name);
                }
                catch (Exception ignore) {
                    try {
                        return SecurityActions.getContextClassLoader().loadClass(name);
                    }
                    catch (Exception e) {
                        throw new PrivilegedActionException(e);
                    }
                }
            }
        });
    }

    static Class<?> loadClass(final ClassLoader cl, final String name) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                if (cl == null) {
                    return SecurityActions.loadClass(name);
                }
                try {
                    return cl.loadClass(name);
                }
                catch (Exception ignore) {
                    return SecurityActions.loadClass(name);
                }
            }
        });
    }
}

