/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.Util;
import org.jboss.security.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleMappingLoginModule
extends AbstractServerLoginModule {
    private static final String REPLACE_ROLE_OPT = "replaceRole";
    private static final String ROLES_PROPERTIES = "rolesProperties";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"replaceRole", "rolesProperties"};
    protected boolean REPLACE_ROLE = false;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    @Override
    public boolean login() throws LoginException {
        if (super.login()) {
            return true;
        }
        this.loginOk = true;
        return true;
    }

    @Override
    protected Principal getIdentity() {
        for (Principal p : this.subject.getPrincipals()) {
            if (p instanceof Group) continue;
            return p;
        }
        return null;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        String propFileName;
        String rep = (String)this.options.get(REPLACE_ROLE_OPT);
        if ("true".equalsIgnoreCase(rep)) {
            this.REPLACE_ROLE = true;
        }
        if ((propFileName = (String)this.options.get(ROLES_PROPERTIES)) == null) {
            throw new LoginException(PicketBoxMessages.MESSAGES.missingRequiredModuleOptionMessage(ROLES_PROPERTIES));
        }
        propFileName = StringPropertyReplacer.replaceProperties(propFileName);
        Group group = this.getExistingRolesFromSubject();
        if (propFileName != null) {
            Properties props = new Properties();
            try {
                props = Util.loadProperties(propFileName);
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugFailureToLoadPropertiesFile(propFileName, (Throwable)e);
            }
            if (props != null) {
                this.processRoles(group, props);
            }
        }
        return new Group[]{group};
    }

    private Group getExistingRolesFromSubject() {
        for (Principal p : this.subject.getPrincipals()) {
            Group g;
            if (!(p instanceof Group) || !"Roles".equals((g = (Group)p).getName())) continue;
            return g;
        }
        return null;
    }

    private void processRoles(Group group, Properties props) {
        Enumeration<?> enumer = props.propertyNames();
        while (enumer.hasMoreElements()) {
            String roleKey = (String)enumer.nextElement();
            String comma_separated_roles = props.getProperty(roleKey);
            try {
                Principal pIdentity = this.createIdentity(roleKey);
                if (group == null) continue;
                if (group.isMember(pIdentity)) {
                    Util.parseGroupMembers(group, comma_separated_roles, this);
                }
                if (!this.REPLACE_ROLE) continue;
                group.removeMember(pIdentity);
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugFailureToCreatePrincipal(roleKey, (Throwable)e);
            }
        }
    }
}

