/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.plugins.vault;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.plugins.PBEUtils;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;
import org.picketbox.commons.cipher.Base64;
import org.picketbox.util.EncryptionUtil;
import org.picketbox.util.KeyStoreUtil;
import org.picketbox.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicketBoxSecurityVault
implements SecurityVault {
    protected boolean finishedInit = false;
    protected KeyStore keystore = null;
    private KeyPair keypair = null;
    protected String encryptionAlgorithm = "AES";
    protected int keySize = 128;
    private char[] keyStorePWD = null;
    protected Map<String, byte[]> theContent = new ConcurrentHashMap<String, byte[]>();
    protected Map<String, byte[]> sharedKeyMap = new ConcurrentHashMap<String, byte[]>();
    public static final String ENC_FILE_DIR = "ENC_FILE_DIR";
    public static final String KEYSTORE_URL = "KEYSTORE_URL";
    public static final String KEYSTORE_PASSWORD = "KEYSTORE_PASSWORD";
    public static final String KEYSTORE_ALIAS = "KEYSTORE_ALIAS";
    public static final String SALT = "SALT";
    public static final String ITERATION_COUNT = "ITERATION_COUNT";
    public static final String PASS_MASK_PREFIX = "MASK-";
    public static final String PUBLIC_CERT = "PUBLIC_CERT";
    public static final String KEY_SIZE = "KEY_SIZE";
    protected static final String ENCODED_FILE = "ENC.dat";
    protected static final String SHARED_KEY_FILE = "Shared.dat";
    protected static final String ADMIN_KEY = "ADMIN_KEY";
    protected String decodedEncFileDir;
    protected String LINE_BREAK = "LINE_BREAK";

    public void init(Map<String, Object> options) throws SecurityVaultException {
        String encFileDir;
        if (options == null || options.isEmpty()) {
            throw PicketBoxMessages.MESSAGES.invalidNullOrEmptyOptionMap("options");
        }
        String keystoreURL = (String)options.get(KEYSTORE_URL);
        if (keystoreURL == null) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.invalidNullOrEmptyOptionMessage(KEYSTORE_URL));
        }
        keystoreURL = StringUtil.getSystemPropertyAsString(keystoreURL.replaceAll(":", "::"));
        String maskedPassword = (String)options.get(KEYSTORE_PASSWORD);
        if (maskedPassword == null) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.invalidNullOrEmptyOptionMessage(KEYSTORE_PASSWORD));
        }
        if (!maskedPassword.startsWith(PASS_MASK_PREFIX)) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.invalidUnmaskedKeystorePasswordMessage());
        }
        String salt = (String)options.get(SALT);
        if (salt == null) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.invalidNullOrEmptyOptionMessage(SALT));
        }
        String iterationCountStr = (String)options.get(ITERATION_COUNT);
        if (iterationCountStr == null) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.invalidNullOrEmptyOptionMessage(ITERATION_COUNT));
        }
        int iterationCount = Integer.parseInt(iterationCountStr);
        String alias = (String)options.get(KEYSTORE_ALIAS);
        if (alias == null) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.invalidNullOrEmptyOptionMessage(KEYSTORE_ALIAS));
        }
        String keySizeStr = (String)options.get(KEY_SIZE);
        if (keySizeStr != null) {
            this.keySize = Integer.parseInt(keySizeStr);
        }
        if ((encFileDir = (String)options.get(ENC_FILE_DIR)) == null) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.invalidNullOrEmptyOptionMessage(ENC_FILE_DIR));
        }
        FileInputStream fis = null;
        FileInputStream mapFile = null;
        ObjectInputStream ois = null;
        ObjectInputStream mapIS = null;
        try {
            this.decodedEncFileDir = StringUtil.getSystemPropertyAsString(encFileDir.replaceAll(":", "::"));
            if (!this.directoryExists(this.decodedEncFileDir)) {
                throw new SecurityVaultException(PicketBoxMessages.MESSAGES.fileOrDirectoryDoesNotExistMessage(this.decodedEncFileDir));
            }
            if (!this.decodedEncFileDir.endsWith("/") && !this.decodedEncFileDir.endsWith("\\")) {
                throw new SecurityVaultException(PicketBoxMessages.MESSAGES.invalidDirectoryFormatMessage(this.decodedEncFileDir));
            }
            if (!this.encodedFileExists(this.decodedEncFileDir)) {
                this.setUpVault(this.decodedEncFileDir);
            }
            fis = new FileInputStream(this.decodedEncFileDir + ENCODED_FILE);
            ois = new ObjectInputStream(fis);
            this.theContent = (Map)ois.readObject();
            mapFile = new FileInputStream(this.decodedEncFileDir + SHARED_KEY_FILE);
            mapIS = new ObjectInputStream(mapFile);
            this.sharedKeyMap = (Map)mapIS.readObject();
            this.safeClose(fis);
            this.safeClose(mapFile);
            this.safeClose(ois);
            this.safeClose(mapIS);
        }
        catch (Exception e) {
            try {
                throw new SecurityVaultException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.safeClose(fis);
                this.safeClose(mapFile);
                this.safeClose(ois);
                this.safeClose(mapIS);
                throw throwable;
            }
        }
        try {
            String keystorePass = this.decode(maskedPassword, salt, iterationCount);
            this.keyStorePWD = keystorePass.toCharArray();
            this.keystore = KeyStoreUtil.getKeyStore(keystoreURL, keystorePass.toCharArray());
            this.keypair = KeyStoreUtil.getPrivateKey(this.keystore, alias, keystorePass.toCharArray());
        }
        catch (Exception e) {
            throw new SecurityVaultException((Throwable)e);
        }
        PicketBoxLogger.LOGGER.infoVaultInitialized();
        this.finishedInit = true;
    }

    public boolean isInitialized() {
        return this.finishedInit;
    }

    public byte[] handshake(Map<String, Object> handshakeOptions) throws SecurityVaultException {
        if (handshakeOptions == null || handshakeOptions.isEmpty()) {
            throw PicketBoxMessages.MESSAGES.invalidNullOrEmptyOptionMap("handshakeOptions");
        }
        String publicCert = (String)handshakeOptions.get(PUBLIC_CERT);
        if (publicCert == null) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.invalidNullOrEmptyOptionMessage(PUBLIC_CERT));
        }
        try {
            PublicKey publicKey = KeyStoreUtil.getPublicKey(this.keystore, publicCert, this.keyStorePWD);
            if (publicKey == null) {
                throw new SecurityVaultException(PicketBoxMessages.MESSAGES.failedToRetrievePublicKeyMessage(publicCert));
            }
        }
        catch (Exception e) {
            throw new SecurityVaultException((Throwable)e);
        }
        StringBuilder uuid = new StringBuilder(UUID.randomUUID().toString());
        uuid.append("LINE_BREAK");
        uuid.append(publicCert);
        return Base64.encodeBytes((byte[])uuid.toString().getBytes()).getBytes();
    }

    public Set<String> keyList() throws SecurityVaultException {
        Set<String> keys = this.theContent.keySet();
        keys.remove(ADMIN_KEY);
        return keys;
    }

    public void store(String vaultBlock, String attributeName, char[] attributeValue, byte[] sharedKey) throws SecurityVaultException {
        Certificate cert;
        if (StringUtil.isNullOrEmpty(vaultBlock)) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("vaultBlock");
        }
        if (StringUtil.isNullOrEmpty(attributeName)) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("attributeName");
        }
        String mapKey = vaultBlock + "_" + attributeName;
        this.sharedKeyMap.put(mapKey, sharedKey);
        String av = new String(attributeValue);
        String decodedSharedKey = new String(Base64.decode((String)new String(sharedKey)));
        int index = decodedSharedKey.indexOf(this.LINE_BREAK);
        if (index < 0) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.invalidSharedKeyMessage());
        }
        String alias = decodedSharedKey.substring(index + this.LINE_BREAK.length());
        try {
            cert = this.keystore.getCertificate(alias);
        }
        catch (KeyStoreException e1) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.failedToRetrieveCertificateMessage(alias), (Throwable)e1);
        }
        EncryptionUtil util = new EncryptionUtil(this.encryptionAlgorithm, this.keySize);
        try {
            byte[] secretKey = this.theContent.get(ADMIN_KEY);
            SecretKeySpec sKeySpec = new SecretKeySpec(secretKey, this.encryptionAlgorithm);
            byte[] encryptedData = util.encrypt(av.getBytes(), cert.getPublicKey(), sKeySpec);
            this.theContent.put(mapKey, encryptedData);
        }
        catch (Exception e1) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.unableToEncryptDataMessage(), (Throwable)e1);
        }
        try {
            this.writeSharedKeyFile(this.decodedEncFileDir);
        }
        catch (IOException e) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.unableToWriteShareKeyFileMessage(), (Throwable)e);
        }
        try {
            this.writeEncodedFile(this.decodedEncFileDir);
        }
        catch (IOException e) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.unableToWriteEncodedFileMessage(), (Throwable)e);
        }
    }

    public char[] retrieve(String vaultBlock, String attributeName, byte[] sharedKey) throws SecurityVaultException {
        if (StringUtil.isNullOrEmpty(vaultBlock)) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("vaultBlock");
        }
        if (StringUtil.isNullOrEmpty(attributeName)) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("attributeName");
        }
        String mapKey = vaultBlock + "_" + attributeName;
        byte[] encryptedValue = this.theContent.get(mapKey);
        byte[] fromMap = this.sharedKeyMap.get(mapKey);
        boolean matches = Arrays.equals(sharedKey, fromMap);
        if (!matches) {
            throw new SecurityVaultException(PicketBoxMessages.MESSAGES.sharedKeyMismatchMessage(vaultBlock, attributeName));
        }
        byte[] secretKey = this.theContent.get(ADMIN_KEY);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, this.encryptionAlgorithm);
        EncryptionUtil encUtil = new EncryptionUtil(this.encryptionAlgorithm, this.keySize);
        try {
            return new String(encUtil.decrypt(encryptedValue, this.keypair, secretKeySpec)).toCharArray();
        }
        catch (Exception e) {
            throw new SecurityVaultException((Throwable)e);
        }
    }

    public boolean exists(String vaultBlock, String attributeName) throws SecurityVaultException {
        String mapKey = vaultBlock + "_" + attributeName;
        return this.theContent.get(mapKey) != null;
    }

    public boolean remove(String vaultBlock, String attributeName, byte[] sharedKey) throws SecurityVaultException {
        String mapKey = vaultBlock + "_" + attributeName;
        try {
            this.theContent.remove(mapKey);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String decode(String maskedString, String salt, int iterationCount) throws Exception {
        String pbeAlgo = "PBEwithMD5andDES";
        if (maskedString.startsWith(PASS_MASK_PREFIX)) {
            String decodedValue;
            SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeAlgo);
            char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
            PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(), iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKey cipherKey = factory.generateSecret(keySpec);
            maskedString = maskedString.substring(PASS_MASK_PREFIX.length());
            maskedString = decodedValue = PBEUtils.decode64(maskedString, pbeAlgo, cipherKey, cipherSpec);
        }
        return maskedString;
    }

    private void setUpVault(String decodedEncFileDir) throws NoSuchAlgorithmException, IOException {
        this.theContent = new ConcurrentHashMap<String, byte[]>();
        EncryptionUtil util = new EncryptionUtil(this.encryptionAlgorithm, this.keySize);
        SecretKey secretKey = util.generateKey();
        this.theContent.put(ADMIN_KEY, secretKey.getEncoded());
        this.writeEncodedFile(decodedEncFileDir);
        this.writeSharedKeyFile(decodedEncFileDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEncodedFile(String decodedEncFileDir) throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(decodedEncFileDir + ENCODED_FILE);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.theContent);
            this.safeClose(oos);
            this.safeClose(fos);
        }
        catch (Throwable throwable) {
            this.safeClose(oos);
            this.safeClose(fos);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSharedKeyFile(String decodedEncFileDir) throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(decodedEncFileDir + SHARED_KEY_FILE);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.sharedKeyMap);
            this.safeClose(oos);
            this.safeClose(fos);
        }
        catch (Throwable throwable) {
            this.safeClose(oos);
            this.safeClose(fos);
            throw throwable;
        }
    }

    private boolean encodedFileExists(String decodedEncFileDir) {
        File file = new File(decodedEncFileDir + ENCODED_FILE);
        return file != null && file.exists();
    }

    private boolean directoryExists(String dir) {
        File file = new File(dir);
        return file != null && file.exists();
    }

    private void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

