/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.jboss.logging.Logger;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.auth.login.SecurityActions;
import org.jboss.security.auth.login.SunConfigParser;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ApplicationPolicyRegistration;
import org.jboss.security.config.PolicyConfig;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.config.parser.StaxBasedConfigParser;

public class XMLLoginConfigImpl
extends Configuration
implements Serializable,
ApplicationPolicyRegistration {
    private static final long serialVersionUID = -8965860493224188277L;
    private static final String DEFAULT_APP_CONFIG_NAME = "other";
    private static final AuthPermission REFRESH_PERM = new AuthPermission("refreshLoginConfiguration");
    private static Logger log = Logger.getLogger(XMLLoginConfigImpl.class);
    private boolean trace = log.isTraceEnabled();
    transient PolicyConfig appConfigs = new PolicyConfig();
    protected URL loginConfigURL;
    protected Configuration parentConfig;
    private boolean validateDTD = true;
    private static final XMLLoginConfigImpl instance = new XMLLoginConfigImpl();

    private XMLLoginConfigImpl() {
    }

    public static XMLLoginConfigImpl getInstance() {
        return instance;
    }

    public void refresh() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Begin refresh");
        }
        this.appConfigs.clear();
        this.loadConfig();
        if (log.isTraceEnabled()) {
            log.trace((Object)"End refresh");
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Begin getAppConfigurationEntry(" + appName + "), size=" + this.appConfigs.size()));
        }
        if (this.appConfigs.size() == 0) {
            this.loadConfig();
        }
        AppConfigurationEntry[] entry = null;
        ApplicationPolicy aPolicy = this.getApplicationPolicy(appName);
        BaseAuthenticationInfo authInfo = null;
        if (aPolicy != null) {
            authInfo = aPolicy.getAuthenticationInfo();
        }
        if (authInfo == null) {
            ApplicationPolicy defPolicy;
            if (log.isTraceEnabled()) {
                log.trace((Object)("getAppConfigurationEntry(" + appName + "), no entry in appConfigs, tyring parentCont: " + this.parentConfig));
            }
            if (this.parentConfig != null) {
                entry = this.parentConfig.getAppConfigurationEntry(appName);
            }
            if (entry == null && log.isTraceEnabled()) {
                log.trace((Object)("getAppConfigurationEntry(" + appName + "), no entry in parentConfig, trying: " + DEFAULT_APP_CONFIG_NAME));
            }
            BaseAuthenticationInfo baseAuthenticationInfo = authInfo = (defPolicy = this.appConfigs.get(DEFAULT_APP_CONFIG_NAME)) != null ? (AuthenticationInfo)defPolicy.getAuthenticationInfo() : null;
        }
        if (authInfo != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("End getAppConfigurationEntry(" + appName + "), authInfo=" + (Object)((Object)authInfo)));
            }
            final BaseAuthenticationInfo theAuthInfo = authInfo;
            PrivilegedAction<AppConfigurationEntry[]> action = new PrivilegedAction<AppConfigurationEntry[]>(){

                @Override
                public AppConfigurationEntry[] run() {
                    return theAuthInfo.copyAppConfigurationEntry();
                }
            };
            entry = AccessController.doPrivileged(action);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("End getAppConfigurationEntry(" + appName + "), failed to find entry"));
        }
        return entry;
    }

    public URL getConfigURL() {
        return this.loginConfigURL;
    }

    public void setConfigURL(URL loginConfigURL) {
        this.loginConfigURL = loginConfigURL;
    }

    public void setConfigResource(String resourceName) throws IOException {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        this.loginConfigURL = tcl.getResource(resourceName);
        if (this.loginConfigURL == null) {
            throw new IOException("PB00015: Null Value:Failed to find resource: " + resourceName);
        }
    }

    public void setParentConfig(Configuration parentConfig) {
        this.parentConfig = parentConfig;
    }

    public boolean getValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateDTD(boolean flag) {
        this.validateDTD = flag;
    }

    public void addApplicationPolicy(String appName, ApplicationPolicy aPolicy) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        this.appConfigs.add(aPolicy);
        this.handleJASPIDelegation(aPolicy);
        SecurityConfiguration.addApplicationPolicy((ApplicationPolicy)aPolicy);
    }

    public void addAppConfig(String appName, AppConfigurationEntry[] entries) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        AuthenticationInfo authInfo = new AuthenticationInfo(appName);
        authInfo.setAppConfigurationEntry(entries);
        if (log.isTraceEnabled()) {
            log.trace((Object)("addAppConfig(" + appName + "), authInfo=" + (Object)((Object)authInfo)));
        }
        ApplicationPolicy aPolicy = new ApplicationPolicy(appName, (BaseAuthenticationInfo)authInfo);
        this.appConfigs.add(aPolicy);
        SecurityConfiguration.addApplicationPolicy((ApplicationPolicy)aPolicy);
    }

    public void copy(PolicyConfig policyConfig) {
        this.appConfigs.copy(policyConfig);
    }

    @Deprecated
    public void removeAppConfig(String appName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("removeAppConfig, appName=" + appName));
        }
        this.appConfigs.remove(appName);
        SecurityConfiguration.removeApplicationPolicy((String)appName);
    }

    public ApplicationPolicy getApplicationPolicy(String domainName) {
        if (this.appConfigs == null || this.appConfigs.size() == 0) {
            this.loadConfig();
        }
        ApplicationPolicy aPolicy = null;
        if (this.appConfigs != null) {
            aPolicy = this.appConfigs.get(domainName);
        }
        if (aPolicy != null) {
            SecurityConfiguration.addApplicationPolicy(aPolicy);
        }
        return aPolicy;
    }

    public boolean removeApplicationPolicy(String appName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("removeAppConfig, appName=" + appName));
        }
        this.appConfigs.remove(appName);
        SecurityConfiguration.removeApplicationPolicy((String)appName);
        return true;
    }

    public BaseAuthenticationInfo getAuthenticationInfo(String domainName) {
        ApplicationPolicy aPolicy = this.getApplicationPolicy(domainName);
        return aPolicy != null ? aPolicy.getAuthenticationInfo() : null;
    }

    public void clear() {
    }

    public void loadConfig() {
        String loginConfig = System.getProperty("java.security.auth.login.config");
        if (loginConfig == null) {
            loginConfig = "login-config.xml";
        }
        if (this.loginConfigURL == null) {
            try {
                this.loginConfigURL = new URL(loginConfig);
            }
            catch (MalformedURLException e) {
                try {
                    this.setConfigResource(loginConfig);
                }
                catch (IOException ignore) {
                    File configFile = new File(loginConfig);
                    try {
                        this.setConfigURL(configFile.toURL());
                    }
                    catch (MalformedURLException ignore2) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.loginConfigURL == null) {
            log.warn((Object)("Failed to find config: " + loginConfig));
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Begin loadConfig, loginConfigURL=" + this.loginConfigURL));
        }
        try {
            this.loadConfig(this.loginConfigURL);
            if (log.isTraceEnabled()) {
                log.trace((Object)("End loadConfig, loginConfigURL=" + this.loginConfigURL));
            }
        }
        catch (Exception e) {
            log.warn((Object)("End loadConfig, failed to load config: " + this.loginConfigURL), (Throwable)e);
        }
    }

    protected String[] loadConfig(URL config) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        ArrayList configNames = new ArrayList();
        log.debug((Object)("Try loading config as XML, url=" + config));
        try {
            this.loadXMLConfig(config, configNames);
        }
        catch (Throwable e) {
            if (this.trace) {
                log.debug((Object)"Failed to load config as XML", e);
                log.debug((Object)("Try loading config as Sun format, url=" + config));
            }
            this.loadSunConfig(config, configNames);
        }
        String[] names = new String[configNames.size()];
        configNames.toArray(names);
        return names;
    }

    private void handleJASPIDelegation(ApplicationPolicy aPolicy) {
        BaseAuthenticationInfo bai = aPolicy.getAuthenticationInfo();
        if (bai instanceof JASPIAuthenticationInfo) {
            LoginModuleStackHolder[] lmsharr;
            JASPIAuthenticationInfo jai = (JASPIAuthenticationInfo)bai;
            for (LoginModuleStackHolder lmsh : lmsharr = jai.getLoginModuleStackHolder()) {
                this.addAppConfig(lmsh.getName(), lmsh.getAppConfigurationEntry());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSunConfig(URL sunConfig, ArrayList configNames) throws Exception {
        InputStream is = null;
        InputStreamReader configFile = null;
        try {
            is = sunConfig.openStream();
            if (is == null) {
                throw new IOException("PB00015: Null Value:InputStream is null for: " + sunConfig);
            }
            configFile = new InputStreamReader(is);
            boolean trace = log.isTraceEnabled();
            SunConfigParser.doParse(configFile, this, trace);
            Object var7_6 = null;
            this.safeClose(configFile);
            this.safeClose(is);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.safeClose(configFile);
            this.safeClose(is);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXMLConfig(URL loginConfigURL, ArrayList configNames) throws Exception {
        InputStream is = null;
        try {
            is = loginConfigURL.openStream();
            StaxBasedConfigParser parser = new StaxBasedConfigParser();
            parser.parse(is);
            Object var6_5 = null;
            this.safeClose(is);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.safeClose(is);
            throw throwable;
        }
    }

    private void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(InputStreamReader fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

