/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociationActions;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLoginModule
implements LoginModule {
    private static Logger log = Logger.getLogger(ClientLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Principal loginPrincipal;
    private Object loginCredential;
    private Map<String, ?> sharedState;
    private boolean useFirstPass;
    private boolean restoreLoginIdentity;
    private boolean trace;
    private SecurityContext cachedSecurityContext;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String passwordStacking;
        String flag;
        this.trace = log.isTraceEnabled();
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        if (this.trace) {
            log.trace((Object)("Security domain: " + (String)options.get("jboss.security.security_domain")));
        }
        if (Boolean.valueOf(flag = (String)options.get("multi-threaded")).booleanValue() && this.trace) {
            log.trace((Object)"Enabling multi-threaded mode");
        }
        if (flag != null && flag.length() > 0 && "false".equalsIgnoreCase(flag)) {
            SecurityAssociationActions.setClient();
        }
        flag = (String)options.get("restore-login-identity");
        this.restoreLoginIdentity = Boolean.valueOf(flag);
        if (this.trace) {
            log.trace((Object)"Enabling restore-login-identity mode");
        }
        boolean bl = this.useFirstPass = (passwordStacking = (String)options.get("password-stacking")) != null;
        if (this.trace && this.useFirstPass) {
            log.trace((Object)"Enabling useFirstPass mode");
        }
        this.cachedSecurityContext = SecurityAssociationActions.getSecurityContext();
    }

    @Override
    public boolean login() throws LoginException {
        if (this.trace) {
            log.trace((Object)"Begin login");
        }
        if (this.useFirstPass) {
            try {
                Object name = this.sharedState.get("javax.security.auth.login.name");
                if (!(name instanceof Principal)) {
                    String username = name != null ? name.toString() : "";
                    this.loginPrincipal = new SimplePrincipal(username);
                } else {
                    this.loginPrincipal = (Principal)name;
                }
                this.loginCredential = this.sharedState.get("javax.security.auth.login.password");
                return true;
            }
            catch (Exception e) {
                log.debug((Object)"Failed to obtain shared state", (Throwable)e);
            }
        }
        if (this.callbackHandler == null) {
            throw new LoginException("PB00015: Null Value:Error: no CallbackHandler available to garner authentication information from the user");
        }
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        NameCallback nc = new NameCallback("User name: ", "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            char[] password = null;
            this.callbackHandler.handle(callbacks);
            String username = nc.getName();
            this.loginPrincipal = new SimplePrincipal(username);
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, password, 0, tmpPassword.length);
                pc.clearPassword();
            }
            this.loginCredential = password;
            if (this.trace) {
                String credType = "null";
                if (this.loginCredential != null) {
                    credType = this.loginCredential.getClass().getName();
                }
                log.trace((Object)("Obtained login: " + this.loginPrincipal + ", credential.class: " + credType));
            }
        }
        catch (IOException ioe) {
            LoginException ex = new LoginException(ioe.toString());
            ex.initCause(ioe);
            throw ex;
        }
        catch (UnsupportedCallbackException uce) {
            LoginException ex = new LoginException("Error: " + uce.getCallback().toString() + ", not able to use this callback for username/password");
            ex.initCause(uce);
            throw ex;
        }
        if (this.trace) {
            log.trace((Object)"End login");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.trace) {
            log.trace((Object)("commit, subject=" + this.subject));
        }
        SecurityAssociationActions.setPrincipalInfo(this.loginPrincipal, this.loginCredential, this.subject);
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.loginPrincipal)) {
            principals.add(this.loginPrincipal);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.trace) {
            log.trace((Object)"abort");
        }
        if (this.restoreLoginIdentity) {
            SecurityAssociationActions.setSecurityContext(this.cachedSecurityContext);
        } else {
            SecurityAssociationActions.clear();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.trace) {
            log.trace((Object)"logout");
        }
        if (this.restoreLoginIdentity) {
            SecurityAssociationActions.setSecurityContext(this.cachedSecurityContext);
        } else {
            SecurityAssociationActions.clear();
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(this.loginPrincipal);
        return true;
    }
}

