/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SimplePrincipal;

public class MappingProviderUtil {
    public static Group addPrincipals(Group grp, Enumeration<? extends Principal> en) {
        while (en.hasMoreElements()) {
            grp.addMember(en.nextElement());
        }
        return grp;
    }

    public static Group addRoles(Group roles, String[] addRoles) {
        Class<?> pClass = MappingProviderUtil.getPrincipalClass(roles);
        for (String str : addRoles) {
            roles.addMember(MappingProviderUtil.instantiatePrincipal(pClass, str));
        }
        return roles;
    }

    public static String[] getRolesFromCommaSeparatedString(String str) {
        if (str == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("str");
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        int numTokens = st != null ? st.countTokens() : 0;
        String[] tokens = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            tokens[i] = st.nextToken();
        }
        return tokens;
    }

    public static Principal instantiatePrincipal(Class<?> cls, String role) {
        Principal p = null;
        try {
            Constructor<?> ctr = cls.getConstructor(String.class);
            p = (Principal)ctr.newInstance(role);
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)e);
        }
        return p;
    }

    public static Group removePrincipals(Group grp) {
        HashSet removeset = new HashSet();
        Enumeration en = grp.members();
        while (en.hasMoreElements()) {
            removeset.add(en.nextElement());
        }
        for (Principal p : removeset) {
            grp.removeMember(p);
        }
        return grp;
    }

    public static Group removeRoles(Group roles, String[] removeRoles) {
        Class<?> pClass = MappingProviderUtil.getPrincipalClass(roles);
        for (String str : removeRoles) {
            roles.removeMember(MappingProviderUtil.instantiatePrincipal(pClass, str));
        }
        return roles;
    }

    public static Group replacePrincipals(Group fg, Group sg) {
        return MappingProviderUtil.addPrincipals(MappingProviderUtil.removePrincipals(fg), sg.members());
    }

    private static Class<?> getPrincipalClass(Group roles) {
        Class principalClass = SimplePrincipal.class;
        Enumeration en = roles.members();
        if (en.hasMoreElements()) {
            principalClass = ((Principal)roles.members().nextElement()).getClass();
        }
        return principalClass;
    }
}

