/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContextAssociation;

public class RunAsLoginModule
implements LoginModule {
    private static final String ROLE_NAME = "roleName";
    private static final String PRINCIPLE_NAME = "principalName";
    private static final String PRINCIPAL_CLASS = "principalClass";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"roleName", "principalName", "principalClass", "jboss.security.security_domain"};
    private String roleName;
    private String principalName;
    private boolean pushedRole;

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        HashSet<String> validOptions = new HashSet<String>(Arrays.asList(ALL_VALID_OPTIONS));
        for (String key : options.keySet()) {
            if (validOptions.contains(key)) continue;
            PicketBoxLogger.LOGGER.warnInvalidModuleOption(key);
        }
        this.roleName = (String)options.get(ROLE_NAME);
        if (this.roleName == null) {
            this.roleName = "nobody";
        }
        this.principalName = (String)options.get(PRINCIPLE_NAME);
        if (this.principalName == null) {
            this.principalName = "nobody";
        }
    }

    @Override
    public boolean login() {
        RunAsIdentity runAsRole = new RunAsIdentity(this.roleName, this.principalName);
        SecurityContextAssociation.pushRunAsIdentity((RunAs)runAsRole);
        this.pushedRole = true;
        return true;
    }

    @Override
    public boolean commit() {
        return this.abort();
    }

    @Override
    public boolean abort() {
        if (!this.pushedRole) {
            return false;
        }
        SecurityContextAssociation.popRunAsIdentity();
        return true;
    }

    @Override
    public boolean logout() {
        return true;
    }
}

