/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;

public class DeploymentRoleToRolesMappingProvider
implements MappingProvider<RoleGroup> {
    private MappingResult<RoleGroup> result;

    public void init(Map<String, Object> options) {
    }

    public void setMappingResult(MappingResult<RoleGroup> res) {
        this.result = res;
    }

    public void performMapping(Map<String, Object> contextMap, RoleGroup mappedObject) {
        if (contextMap == null || contextMap.isEmpty()) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextMap");
        }
        Principal principal = (Principal)contextMap.get("Principal");
        Map roleToRolesMap = (Map)contextMap.get("deploymentPrincipalRolesMap");
        Set subjectPrincipals = (Set)contextMap.get("PrincipalsSet");
        PicketBoxLogger.LOGGER.debugMappingProviderOptions(principal, roleToRolesMap, subjectPrincipals);
        if (roleToRolesMap == null || roleToRolesMap.isEmpty()) {
            this.result.setMappedObject((Object)mappedObject);
            return;
        }
        SimpleRoleGroup newRoles = new SimpleRoleGroup("Roles");
        SimpleRoleGroup assignedRoles = (SimpleRoleGroup)contextMap.get("Roles");
        if (assignedRoles != null) {
            for (Role r : assignedRoles.getRoles()) {
                boolean mappedRoleIncluded = false;
                for (String mappedRole : roleToRolesMap.keySet()) {
                    if (!((Set)roleToRolesMap.get(mappedRole)).contains(r.getRoleName())) continue;
                    newRoles.addRole((Role)new SimpleRole(mappedRole));
                    mappedRoleIncluded = true;
                }
                if (mappedRoleIncluded) continue;
                newRoles.addRole(r);
            }
        }
        if (assignedRoles != null) {
            mappedObject.clearRoles();
            mappedObject.addAll(newRoles.getRoles());
        }
        this.result.setMappedObject((Object)mappedObject);
    }

    public boolean supports(Class<?> p) {
        return RoleGroup.class.isAssignableFrom(p);
    }
}

