/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.util.Map;
import javax.security.auth.Subject;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.ejb.EJBPolicyModuleDelegate;
import org.jboss.security.authorization.modules.ejb.EJBXACMLUtil;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.jboss.security.xacml.interfaces.ResponseContext;

public class EJBXACMLPolicyModuleDelegate
extends EJBPolicyModuleDelegate {
    private String policyContextID;

    @Override
    public int authorize(Resource resource, Subject callerSubject, RoleGroup role) {
        if (!(resource instanceof EJBResource)) {
            throw PicketBoxMessages.MESSAGES.invalidType(EJBResource.class.getName());
        }
        EJBResource ejbResource = (EJBResource)resource;
        Map map = resource.getMap();
        if (map == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("resourceMap");
        }
        this.policyRegistration = (PolicyRegistration)map.get("policyRegistration");
        if (this.policyRegistration == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("policyRegistration");
        }
        this.callerRunAs = ejbResource.getCallerRunAsIdentity();
        this.ejbName = ejbResource.getEjbName();
        this.ejbMethod = ejbResource.getEjbMethod();
        this.ejbPrincipal = ejbResource.getPrincipal();
        this.policyContextID = ejbResource.getPolicyContextID();
        if (this.policyContextID == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("contextID");
        }
        this.securityRoleReferences = ejbResource.getSecurityRoleReferences();
        this.roleName = (String)map.get("roleName");
        Boolean roleRefCheck = this.checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
        if (roleRefCheck.booleanValue()) {
            return this.checkRoleRef(role);
        }
        return this.process(role);
    }

    private int process(RoleGroup callerRoles) {
        int result = -1;
        EJBXACMLUtil util = new EJBXACMLUtil();
        try {
            RequestContext requestCtx = util.createXACMLRequest(this.ejbName, this.ejbMethod, this.ejbPrincipal, callerRoles);
            PolicyDecisionPoint pdp = util.getPDP(this.policyRegistration, this.policyContextID);
            if (pdp == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullProperty("PDP");
            }
            ResponseContext response = pdp.evaluate(requestCtx);
            result = response.getDecision() == 0 ? 1 : -1;
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)e);
            result = -1;
        }
        return result;
    }

    private Boolean checkBooleanValue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }
}

