/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Users {
    private HashMap<String, User> users = new HashMap();

    public void addUser(User user) {
        this.users.put(user.getName(), user);
    }

    public Iterator<User> getUsers() {
        return this.users.values().iterator();
    }

    public User getUser(String name) {
        User find = this.users.get(name);
        return find;
    }

    public int size() {
        return this.users.size();
    }

    public String toString() {
        return "Users(" + System.identityHashCode(this) + "){users=" + this.users + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class User
    implements Comparable<User> {
        private String name;
        private String password;
        private String encoding;
        private HashMap<String, Group> roleGroups = new HashMap();

        public User() {
        }

        public User(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public Group[] getRoleSets() {
            Group[] roleSets = new Group[this.roleGroups.size()];
            this.roleGroups.values().toArray(roleSets);
            return roleSets;
        }

        public String[] getRoleNames() {
            return this.getRoleNames("Roles");
        }

        public String[] getRoleNames(String roleGroup) {
            Group group = this.roleGroups.get(roleGroup);
            String[] names = new String[]{};
            if (group != null) {
                ArrayList<String> tmp = new ArrayList<String>();
                Enumeration iter = group.members();
                while (iter.hasMoreElements()) {
                    Principal p = (Principal)iter.nextElement();
                    tmp.add(p.getName());
                }
                names = new String[tmp.size()];
                tmp.toArray(names);
            }
            return names;
        }

        public void addRole(String roleName, String roleGroup) {
            Group group = this.roleGroups.get(roleGroup);
            if (group == null) {
                group = new SimpleGroup(roleGroup);
                this.roleGroups.put(roleGroup, group);
            }
            SimplePrincipal role = new SimplePrincipal(roleName);
            group.addMember((Principal)role);
        }

        @Override
        public int compareTo(User obj) {
            return this.name.compareTo(obj.name);
        }

        public String toString() {
            return "User{name='" + this.name + "', password=*, encoding='" + this.encoding + "', roleGroups=" + this.roleGroups + "}";
        }
    }
}

