/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.identitytrust;

import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityContext;
import org.jboss.security.identitytrust.IdentityTrustContext;
import org.jboss.security.identitytrust.IdentityTrustException;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.identitytrust.JBossIdentityTrustContext;

public class JBossIdentityTrustManager
implements IdentityTrustManager {
    private String securityDomain = null;
    private IdentityTrustContext identityTrustContext = null;

    public JBossIdentityTrustManager(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public void setIdentityTrustContext(IdentityTrustContext identityTrustContext) {
        if (identityTrustContext == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("identityTrustContext");
        }
        this.identityTrustContext = identityTrustContext;
    }

    public IdentityTrustManager.TrustDecision isTrusted(SecurityContext securityContext) {
        if (securityContext == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("securityContext");
        }
        if (this.identityTrustContext == null) {
            this.identityTrustContext = new JBossIdentityTrustContext(this.securityDomain, securityContext);
        }
        IdentityTrustManager.TrustDecision td = IdentityTrustManager.TrustDecision.NotApplicable;
        if (this.identityTrustContext == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("identityTrustContext");
        }
        try {
            td = this.identityTrustContext.isTrusted();
        }
        catch (IdentityTrustException e) {
            PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)e);
        }
        return td;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }
}

