/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.web;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.authorization.modules.web.WebXACMLUtil;
import org.jboss.security.authorization.resources.WebResource;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.jboss.security.xacml.interfaces.ResponseContext;

public class WebXACMLPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    private String policyContextID = null;

    public int authorize(Resource resource, Subject subject, RoleGroup role) {
        if (!(resource instanceof WebResource)) {
            throw PicketBoxMessages.MESSAGES.invalidType(WebResource.class.getName());
        }
        WebResource webResource = (WebResource)resource;
        Map map = resource.getMap();
        if (map == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("resourceMap");
        }
        HttpServletRequest request = (HttpServletRequest)webResource.getServletRequest();
        this.policyRegistration = (PolicyRegistration)map.get("policyRegistration");
        if (this.policyRegistration == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("policyRegistration");
        }
        this.policyContextID = webResource.getPolicyContextID();
        Boolean userDataCheck = this.checkBooleanValue((Boolean)map.get("userDataPermissionCheck"));
        Boolean roleRefCheck = this.checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
        if (userDataCheck.booleanValue() || roleRefCheck.booleanValue()) {
            return 1;
        }
        if (request == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("servletRequest");
        }
        return this.process(request, role);
    }

    private Boolean checkBooleanValue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }

    private int process(HttpServletRequest request, RoleGroup callerRoles) {
        Principal userP = request.getUserPrincipal();
        if (userP == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("userPrincipal");
        }
        int result = -1;
        WebXACMLUtil util = new WebXACMLUtil();
        try {
            PolicyDecisionPoint pdp;
            ResponseContext response;
            RequestContext requestCtx = util.createXACMLRequest(request, callerRoles);
            if (this.policyContextID == null) {
                this.policyContextID = PolicyContext.getContextID();
            }
            result = (response = (pdp = util.getPDP(this.policyRegistration, this.policyContextID)).evaluate(requestCtx)).getDecision() == 0 ? 1 : -1;
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugIgnoredException((Throwable)e);
            result = -1;
        }
        return result;
    }
}

