/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.AuthorizationModule;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.ResourceType;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.authorization.modules.SecurityActions;
import org.jboss.security.identity.RoleGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthorizationModule
implements AuthorizationModule {
    protected Subject subject = null;
    protected CallbackHandler handler = null;
    protected Map<String, Object> sharedState = null;
    protected Map<String, Object> options = null;
    protected RoleGroup role = null;
    protected Map<ResourceType, String> delegateMap = new HashMap<ResourceType, String>();
    protected static Map<String, Class<?>> clazzMap = new HashMap();

    public abstract int authorize(Resource var1);

    public boolean abort() throws AuthorizationException {
        return true;
    }

    public boolean commit() throws AuthorizationException {
        return true;
    }

    public boolean destroy() {
        this.subject = null;
        this.handler = null;
        this.sharedState = null;
        this.options = null;
        return true;
    }

    public void initialize(Subject subject, CallbackHandler handler, Map<String, Object> sharedState, Map<String, Object> options, RoleGroup subjectRole) {
        String commaSeparatedDelegates;
        this.subject = subject;
        this.handler = handler;
        this.sharedState = sharedState;
        this.options = options;
        if (options != null && (commaSeparatedDelegates = (String)options.get("delegateMap")) != null && commaSeparatedDelegates.length() > 0) {
            this.populateDelegateMap(commaSeparatedDelegates);
        }
        this.role = subjectRole;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Name=" + this.getClass().getName());
        buf.append(":subject=" + this.subject);
        buf.append(":role=" + this.role);
        return buf.toString();
    }

    protected int invokeDelegate(Resource resource) {
        int authorizationDecision = -1;
        ResourceType layer = resource.getLayer();
        String delegateStr = this.delegateMap.get(layer);
        if (delegateStr == null) {
            throw PicketBoxMessages.MESSAGES.missingDelegateForLayer(layer != null ? layer.toString() : null);
        }
        AuthorizationModuleDelegate delegate = null;
        try {
            delegate = this.getDelegate(delegateStr);
            authorizationDecision = delegate.authorize(resource, this.subject, this.role);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
            ise.initCause(e);
            throw ise;
        }
        return authorizationDecision;
    }

    protected AuthorizationModuleDelegate getDelegate(String delegateStr) throws Exception {
        Class<?> clazz = clazzMap.get(delegateStr);
        if (clazz == null) {
            try {
                clazz = this.getClass().getClassLoader().loadClass(delegateStr);
            }
            catch (Exception e) {
                ClassLoader tcl = SecurityActions.getContextClassLoader();
                clazz = tcl.loadClass(delegateStr);
            }
            clazzMap.put(delegateStr, clazz);
        }
        return (AuthorizationModuleDelegate)clazz.newInstance();
    }

    protected void populateDelegateMap(String commaSeparatedDelegates) {
        StringTokenizer st = new StringTokenizer(commaSeparatedDelegates, ",");
        while (st.hasMoreTokens()) {
            String keyPair = st.nextToken();
            StringTokenizer keyst = new StringTokenizer(keyPair, "=");
            if (keyst.countTokens() != 2) {
                throw PicketBoxMessages.MESSAGES.invalidDelegateMapEntry(keyPair);
            }
            String key = keyst.nextToken();
            String value = keyst.nextToken();
            this.delegateMap.put(ResourceType.valueOf((String)key), value);
        }
    }
}

