/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.jboss.security.RunAs;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRoleGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAsIdentity
extends SimplePrincipal
implements Cloneable,
RunAs {
    private static final long serialVersionUID = -3236178735180485083L;
    private HashSet<Principal> runAsRoles = new HashSet();
    private HashSet<Principal> principalsSet;
    private static final String ANOYMOUS_PRINCIPAL = "anonymous";

    public RunAsIdentity(String roleName, String principalName) {
        super(principalName != null ? principalName : ANOYMOUS_PRINCIPAL);
        if (roleName == null) {
            throw new IllegalArgumentException("PB00014: Null Argument:The run-as identity must have at least one role");
        }
        this.runAsRoles.add(new SimplePrincipal(roleName));
    }

    public RunAsIdentity(String roleName, String principalName, Set<String> extraRoleNames) {
        this(roleName, principalName);
        if (extraRoleNames != null) {
            for (String extraRoleName : extraRoleNames) {
                this.runAsRoles.add(new SimplePrincipal(extraRoleName));
            }
        }
    }

    public Set<Principal> getRunAsRoles() {
        return new HashSet<Principal>(this.runAsRoles);
    }

    public RoleGroup getRunAsRolesAsRoleGroup() {
        return new SimpleRoleGroup(this.runAsRoles);
    }

    public synchronized Set<Principal> getPrincipalsSet() {
        if (this.principalsSet == null) {
            this.principalsSet = new HashSet();
            this.principalsSet.add(this);
            SimpleGroup roles = new SimpleGroup("Roles");
            this.principalsSet.add(roles);
            for (Principal role : this.runAsRoles) {
                roles.addMember(role);
            }
        }
        return this.principalsSet;
    }

    public boolean doesUserHaveRole(Principal role) {
        return this.runAsRoles.contains(role);
    }

    public boolean doesUserHaveRole(Set<Principal> methodRoles) {
        for (Principal role : methodRoles) {
            if (!this.doesUserHaveRole(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "[roles=" + this.runAsRoles + ",principal=" + this.getName() + "]";
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        RunAsIdentity clone = (RunAsIdentity)super.clone();
        if (clone != null) {
            clone.principalsSet = this.principalsSet != null ? (HashSet)this.principalsSet.clone() : null;
            clone.runAsRoles = (HashSet)this.runAsRoles.clone();
        }
        return clone;
    }

    public <T> T getIdentity() {
        return (T)this.getName();
    }

    public <T> T getProof() {
        return (T)"JavaEE";
    }
}

