/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.web;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.util.JBossXACMLUtil;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.xacml.core.model.context.ActionType;
import org.jboss.security.xacml.core.model.context.AttributeType;
import org.jboss.security.xacml.core.model.context.EnvironmentType;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResourceType;
import org.jboss.security.xacml.core.model.context.SubjectType;
import org.jboss.security.xacml.factories.RequestAttributeFactory;
import org.jboss.security.xacml.factories.RequestResponseContextFactory;
import org.jboss.security.xacml.interfaces.RequestContext;

public class WebXACMLUtil
extends JBossXACMLUtil {
    private static Logger log = Logger.getLogger(WebXACMLUtil.class);
    private boolean trace = log.isTraceEnabled();

    public RequestContext createXACMLRequest(HttpServletRequest request, RoleGroup callerRoles) throws Exception {
        if (request == null) {
            throw new IllegalArgumentException("PB00014: Null Argument:Http Request is null");
        }
        if (callerRoles == null) {
            throw new IllegalArgumentException("PB00014: Null Argument:roles is null");
        }
        String httpMethod = request.getMethod();
        String action = "GET".equals(httpMethod) ? "read" : "write";
        String actionURIBase = "urn:oasis:names:tc:xacml:2.0:request-param:attribute:";
        Principal principal = request.getUserPrincipal();
        RequestContext requestCtx = RequestResponseContextFactory.createRequestCtx();
        SubjectType subject = new SubjectType();
        subject.getAttribute().add(RequestAttributeFactory.createStringAttributeType((String)"urn:oasis:names:tc:xacml:1.0:subject:subject-id", (String)"jboss.org", (String)principal.getName()));
        List rolesList = callerRoles.getRoles();
        if (rolesList != null) {
            for (Role role : rolesList) {
                String roleName = role.getRoleName();
                AttributeType attSubjectID = RequestAttributeFactory.createStringAttributeType((String)"urn:oasis:names:tc:xacml:2.0:subject:role", (String)"jboss.org", (String)roleName);
                subject.getAttribute().add(attSubjectID);
            }
        }
        ResourceType resourceType = new ResourceType();
        resourceType.getAttribute().add(RequestAttributeFactory.createAnyURIAttributeType((String)"urn:oasis:names:tc:xacml:1.0:resource:resource-id", null, (URI)new URI(request.getRequestURI())));
        ActionType actionType = new ActionType();
        actionType.getAttribute().add(RequestAttributeFactory.createStringAttributeType((String)"urn:oasis:names:tc:xacml:1.0:action:action-id", (String)"jboss.org", (String)action));
        Enumeration enumer = request.getParameterNames();
        while (enumer.hasMoreElements()) {
            String paramName = (String)enumer.nextElement();
            String paramValue = request.getParameter(paramName);
            URI actionUri = new URI(actionURIBase + paramName);
            actionType.getAttribute().add(RequestAttributeFactory.createStringAttributeType((String)actionUri.toASCIIString(), (String)"jboss.org", (String)paramValue));
        }
        EnvironmentType environmentType = new EnvironmentType();
        environmentType.getAttribute().add(RequestAttributeFactory.createDateTimeAttributeType((String)"urn:oasis:names:tc:xacml:1.0:environment:current-time", null));
        RequestType requestType = new RequestType();
        requestType.getSubject().add(subject);
        requestType.getResource().add(resourceType);
        requestType.setAction(actionType);
        requestType.setEnvironment(environmentType);
        requestCtx.setRequest(requestType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.trace) {
            requestCtx.marshall((OutputStream)baos);
            log.trace((Object)new String(baos.toByteArray()));
        }
        return requestCtx;
    }
}

