/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SubjectActions {
    private static Logger log = Logger.getLogger(SubjectActions.class);

    SubjectActions() {
    }

    static Subject getActiveSubject() {
        Subject subject = AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    static void copySubject(Subject fromSubject, Subject toSubject) {
        SubjectActions.copySubject(fromSubject, toSubject, false);
    }

    static void copySubject(Subject fromSubject, Subject toSubject, boolean setReadOnly) {
        CopySubjectAction action = new CopySubjectAction(fromSubject, toSubject, setReadOnly);
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            action.run();
        }
    }

    static void copySubject(Subject fromSubject, Subject toSubject, boolean setReadOnly, boolean deepCopy) {
        CopySubjectAction action = new CopySubjectAction(fromSubject, toSubject, setReadOnly);
        action.setDeepCopy(deepCopy);
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            action.run();
        }
    }

    static LoginContext createLoginContext(String securityDomain, Subject subject, CallbackHandler handler) throws LoginException {
        LoginContextAction action = new LoginContextAction(securityDomain, subject, handler);
        try {
            LoginContext lc = AccessController.doPrivileged(action);
            return lc;
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException(ex.getMessage());
        }
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    static Object setContextInfo(String key, Object value) {
        SetContextInfoAction action = new SetContextInfoAction(key, value);
        Object prevInfo = AccessController.doPrivileged(action);
        return prevInfo;
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject, String securityDomain) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject, securityDomain);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject, securityDomain);
        }
    }

    static void popSubjectContext() {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.pop();
        } else {
            PrincipalInfoAction.PRIVILEGED.pop();
        }
    }

    static String toString(Subject subject) {
        ToStringSubjectAction action = new ToStringSubjectAction(subject);
        String info = AccessController.doPrivileged(action);
        return info;
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static String getRefreshSecurityContextRoles() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("jbosssx.context.roles.refresh", "false");
            }
        });
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    static Principal getPrincipal() {
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                Principal principal = null;
                SecurityContext sc = SubjectActions.getSecurityContext();
                if (sc != null) {
                    principal = sc.getUtil().getUserPrincipal();
                }
                return principal;
            }
        });
    }

    static Object getCredential() {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Object credential = null;
                SecurityContext sc = SubjectActions.getSecurityContext();
                if (sc != null) {
                    credential = sc.getUtil().getCredential();
                }
                return credential;
            }
        });
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            public void push(final Principal principal, final Object credential, final Subject subject, final String securityDomain) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                        if (sc == null) {
                            try {
                                sc = SecurityContextFactory.createSecurityContext((Principal)principal, (Object)credential, (Subject)subject, (String)securityDomain);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                        return null;
                    }
                });
            }

            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        SecurityContextAssociation.clearSecurityContext();
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject, String securityDomain) {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    try {
                        sc = SecurityContextFactory.createSecurityContext((Principal)principal, (Object)credential, (Subject)subject, (String)securityDomain);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    sc.getUtil().createSubjectInfo(principal, credential, subject);
                }
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
            }

            public void pop() {
                SecurityContextAssociation.clearSecurityContext();
            }
        };

        public void push(Principal var1, Object var2, Subject var3, String var4);

        public void pop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetContextInfoAction
    implements PrivilegedAction<Object> {
        String key;
        Object value;

        SetContextInfoAction(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Object run() {
            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
            if (sc != null) {
                sc.getData().put(this.key, this.value);
            }
            return SecurityContextAssociation.setContextInfo((String)this.key, (Object)this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetTCLAction
    implements PrivilegedAction<ClassLoader> {
        static PrivilegedAction<ClassLoader> ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        @Override
        public ClassLoader run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoginContextAction
    implements PrivilegedExceptionAction<LoginContext> {
        String securityDomain;
        Subject subject;
        CallbackHandler handler;

        LoginContextAction(String securityDomain, Subject subject, CallbackHandler handler) {
            this.securityDomain = securityDomain;
            this.subject = subject;
            this.handler = handler;
        }

        @Override
        public LoginContext run() throws Exception {
            LoginContext lc = new LoginContext(this.securityDomain, this.subject, this.handler);
            return lc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopySubjectAction
    implements PrivilegedAction<Object> {
        Subject fromSubject;
        Subject toSubject;
        boolean setReadOnly;
        boolean deepCopy;

        CopySubjectAction(Subject fromSubject, Subject toSubject, boolean setReadOnly) {
            this.fromSubject = fromSubject;
            this.toSubject = toSubject;
            this.setReadOnly = setReadOnly;
        }

        public void setDeepCopy(boolean flag) {
            this.deepCopy = flag;
        }

        @Override
        public Object run() {
            Set<Principal> principals = this.fromSubject.getPrincipals();
            Set<Principal> principals2 = this.toSubject.getPrincipals();
            Iterator<Principal> iter = principals.iterator();
            while (iter.hasNext()) {
                principals2.add((Principal)this.getCloneIfNeeded(iter.next()));
            }
            Set<Object> privateCreds = this.fromSubject.getPrivateCredentials();
            Set<Object> privateCreds2 = this.toSubject.getPrivateCredentials();
            Iterator<Object> iterCred = privateCreds.iterator();
            while (iterCred.hasNext()) {
                privateCreds2.add(this.getCloneIfNeeded(iter.next()));
            }
            Set<Object> publicCreds = this.fromSubject.getPublicCredentials();
            Set<Object> publicCreds2 = this.toSubject.getPublicCredentials();
            iterCred = publicCreds.iterator();
            while (iterCred.hasNext()) {
                publicCreds2.add(this.getCloneIfNeeded(iter.next()));
            }
            if (this.setReadOnly) {
                this.toSubject.setReadOnly();
            }
            return null;
        }

        private Object getCloneIfNeeded(Object obj) {
            Object clonedObject = null;
            if (this.deepCopy && obj instanceof Cloneable) {
                Class<?> clazz = obj.getClass();
                try {
                    Method cloneMethod = clazz.getMethod("clone", null);
                    clonedObject = cloneMethod.invoke(obj, (Object[])null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (clonedObject == null) {
                clonedObject = obj;
            }
            return clonedObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetSubjectAction
    implements PrivilegedAction<Subject> {
        static PrivilegedAction<Subject> ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        @Override
        public Subject run() {
            Subject subject = null;
            try {
                subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            }
            catch (PolicyContextException pce) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Error obtaining subject:", (Throwable)pce);
                }
                SecurityContext sc = SubjectActions.getSecurityContext();
                subject = sc.getUtil().getSubject();
            }
            return subject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToStringSubjectAction
    implements PrivilegedAction<String> {
        Subject subject;

        ToStringSubjectAction(Subject subject) {
            this.subject = subject;
        }

        @Override
        public String run() {
            StringBuffer tmp = new StringBuffer();
            tmp.append("Subject(");
            tmp.append(System.identityHashCode(this.subject));
            tmp.append(").principals=");
            for (Principal p : this.subject.getPrincipals()) {
                Class<?> c = p.getClass();
                tmp.append(c.getName());
                tmp.append('@');
                tmp.append(System.identityHashCode(c));
                tmp.append('(');
                tmp.append(p);
                tmp.append(')');
            }
            return tmp.toString();
        }
    }
}

