/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;

public class RoleFactory {
    private static String SIMPLE_ROLE_CLASS = "org.jboss.security.identity.plugins.SimpleRole";
    private static String SIMPLE_ROLEGROUP_CLASS = "org.jboss.security.identity.plugins.SimpleRoleGroup";
    private static Map<String, Class<?>> clazzMap = new WeakHashMap();

    public static Role createRole(final String name) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Role>(){

            @Override
            public Role run() throws Exception {
                Class<?> clazz = (Class<?>)clazzMap.get(SIMPLE_ROLE_CLASS);
                if (clazz == null) {
                    try {
                        clazz = this.getClass().getClassLoader().loadClass(name);
                    }
                    catch (Exception e) {
                        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                        clazz = tcl.loadClass(SIMPLE_ROLE_CLASS);
                    }
                }
                Constructor<?> ctr = clazz.getConstructor(String.class);
                return (Role)ctr.newInstance(name);
            }
        });
    }

    public static RoleGroup createRoleGroup(final String name) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<RoleGroup>(){

            @Override
            public RoleGroup run() throws Exception {
                Class<?> clazz = (Class<?>)clazzMap.get(SIMPLE_ROLEGROUP_CLASS);
                if (clazz == null) {
                    try {
                        clazz = this.getClass().getClassLoader().loadClass(name);
                    }
                    catch (Exception e) {
                        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                        clazz = tcl.loadClass(SIMPLE_ROLEGROUP_CLASS);
                    }
                }
                Constructor<?> ctr = clazz.getConstructor(String.class);
                return (RoleGroup)ctr.newInstance(name);
            }
        });
    }

    public static void setSimpleRoleClass(String fqn) {
        SIMPLE_ROLE_CLASS = fqn;
    }

    public static void setSimpleRoleGroupClass(String fqn) {
        SIMPLE_ROLEGROUP_CLASS = fqn;
    }
}

