/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.event;

import edu.umd.cs.piccolox.event.PNotification;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PNotificationCenter {
    public static final Object NULL_MARKER = new Object();
    protected static volatile PNotificationCenter DEFAULT_CENTER;
    protected HashMap listenersMap = new HashMap();
    protected ReferenceQueue keyQueue = new ReferenceQueue();

    public static PNotificationCenter defaultCenter() {
        if (DEFAULT_CENTER == null) {
            DEFAULT_CENTER = new PNotificationCenter();
        }
        return DEFAULT_CENTER;
    }

    private PNotificationCenter() {
    }

    public boolean addListener(Object listener, String callbackMethodName, String notificationName, Object object) {
        this.processKeyQueue();
        Object name = this.nullify(notificationName);
        Object sanitizedObject = this.nullify(object);
        Method method = this.extractCallbackMethod(listener, callbackMethodName);
        if (method == null) {
            return false;
        }
        NotificationKey key = new NotificationKey(name, sanitizedObject);
        NotificationTarget notificationTarget = new NotificationTarget(listener, method);
        ArrayList<NotificationTarget> list = (ArrayList<NotificationTarget>)this.listenersMap.get(key);
        if (list == null) {
            list = new ArrayList<NotificationTarget>();
            this.listenersMap.put(new NotificationKey(name, sanitizedObject, this.keyQueue), list);
        }
        if (!list.contains(notificationTarget)) {
            list.add(notificationTarget);
        }
        return true;
    }

    private Method extractCallbackMethod(Object listener, String methodName) {
        Method method = null;
        try {
            Class[] classes = new Class[]{PNotification.class};
            method = listener.getClass().getMethod(methodName, classes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return null;
        }
        return method;
    }

    private Object nullify(Object object) {
        if (object == null) {
            return NULL_MARKER;
        }
        return object;
    }

    public void removeListener(Object listener) {
        this.processKeyQueue();
        Iterator i = new LinkedList(this.listenersMap.keySet()).iterator();
        while (i.hasNext()) {
            this.removeListener(listener, i.next());
        }
    }

    public void removeListener(Object listener, String notificationName, Object object) {
        this.processKeyQueue();
        List keys = this.matchingKeys(notificationName, object);
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.removeListener(listener, it.next());
        }
    }

    public void postNotification(String notificationName, Object object) {
        this.postNotification(notificationName, object, null);
    }

    public void postNotification(String notificationName, Object object, Map properties) {
        this.postNotification(new PNotification(notificationName, object, properties));
    }

    public void postNotification(PNotification notification) {
        LinkedList mergedListeners = new LinkedList();
        String name = notification.getName();
        Object object = notification.getObject();
        if (name != null && object != null) {
            this.fillWithMatchingListeners(name, object, mergedListeners);
            this.fillWithMatchingListeners(null, object, mergedListeners);
            this.fillWithMatchingListeners(name, null, mergedListeners);
        } else if (name != null) {
            this.fillWithMatchingListeners(name, null, mergedListeners);
        } else if (object != null) {
            this.fillWithMatchingListeners(null, object, mergedListeners);
        }
        this.fillWithMatchingListeners(null, null, mergedListeners);
        this.dispatchNotifications(notification, mergedListeners);
    }

    private void fillWithMatchingListeners(Object notificationName, Object object, List listeners) {
        NotificationKey key = new NotificationKey(this.nullify(notificationName), this.nullify(object));
        List globalListeners = (List)this.listenersMap.get(key);
        if (globalListeners != null) {
            listeners.addAll(globalListeners);
        }
    }

    private void dispatchNotifications(PNotification notification, List listeners) {
        Iterator listenerIterator = listeners.iterator();
        while (listenerIterator.hasNext()) {
            NotificationTarget listener = (NotificationTarget)listenerIterator.next();
            if (listener.get() == null) {
                listenerIterator.remove();
                continue;
            }
            this.notifyListener(notification, listener);
        }
    }

    private void notifyListener(PNotification notification, NotificationTarget listener) {
        try {
            Object[] objects = new Object[]{notification};
            listener.getMethod().invoke(listener.get(), objects);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Impossible Situation: invoking inaccessible method on listener", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected List matchingKeys(String name, Object object) {
        LinkedList<NotificationKey> result = new LinkedList<NotificationKey>();
        NotificationKey searchKey = new NotificationKey(name, object);
        Iterator it = this.listenersMap.keySet().iterator();
        while (it.hasNext()) {
            NotificationKey key = (NotificationKey)it.next();
            if (!searchKey.equals(key)) continue;
            result.add(key);
        }
        return result;
    }

    protected void removeListener(Object listener, Object key) {
        if (listener == null) {
            this.listenersMap.remove(key);
            return;
        }
        List list = (List)this.listenersMap.get(key);
        if (list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object observer = ((NotificationTarget)it.next()).get();
            if (observer != null && listener != observer) continue;
            it.remove();
        }
        if (list.size() == 0) {
            this.listenersMap.remove(key);
        }
    }

    protected void processKeyQueue() {
        NotificationKey key;
        while ((key = (NotificationKey)this.keyQueue.poll()) != null) {
            this.listenersMap.remove(key);
        }
    }

    protected static class NotificationTarget
    extends WeakReference {
        protected int hashCode;
        protected Method method;

        public NotificationTarget(Object object, Method method) {
            super(object);
            this.hashCode = object.hashCode() + method.hashCode();
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof NotificationTarget)) {
                return false;
            }
            NotificationTarget target = (NotificationTarget)object;
            if (!(this.method == target.method || this.method != null && this.method.equals(target.method))) {
                return false;
            }
            Object o = this.get();
            return o != null && o == target.get();
        }

        public String toString() {
            return "[CompoundValue:" + this.get() + ":" + this.getMethod().getName() + "]";
        }
    }

    protected static class NotificationKey
    extends WeakReference {
        private final Object name;
        private final int hashCode;

        public NotificationKey(Object name, Object object) {
            super(object);
            this.name = name;
            this.hashCode = name.hashCode() + object.hashCode();
        }

        public NotificationKey(Object name, Object object, ReferenceQueue queue) {
            super(object, queue);
            this.name = name;
            this.hashCode = name.hashCode() + object.hashCode();
        }

        public Object name() {
            return this.name;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (!(anObject instanceof NotificationKey)) {
                return false;
            }
            NotificationKey key = (NotificationKey)anObject;
            if (!(this.name == key.name || this.name != null && this.name.equals(key.name))) {
                return false;
            }
            Object object = this.get();
            return object != null && object == key.get();
        }

        public String toString() {
            return "[CompoundKey:" + this.name() + ":" + this.get() + "]";
        }
    }
}

