/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PStack;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.event.EventListenerList;

public class PPickPath
implements PInputEventListener {
    public static PPickPath CURRENT_PICK_PATH;
    private static final double[] PTS;
    private PStack nodeStack;
    private final PCamera topCamera;
    private PStack transformStack;
    private PStack pickBoundsStack = new PStack();
    private PCamera bottomCamera;
    private HashMap excludedNodes;
    static /* synthetic */ Class class$edu$umd$cs$piccolo$event$PInputEventListener;

    public PPickPath(PCamera camera, PBounds aScreenPickBounds) {
        this.topCamera = camera;
        this.nodeStack = new PStack();
        this.transformStack = new PStack();
        this.pickBoundsStack.push(aScreenPickBounds);
        CURRENT_PICK_PATH = this;
    }

    public PBounds getPickBounds() {
        return (PBounds)this.pickBoundsStack.peek();
    }

    public boolean acceptsNode(PNode node) {
        return this.excludedNodes == null || !this.excludedNodes.containsKey(node);
    }

    public void pushNode(PNode node) {
        this.nodeStack.push(node);
    }

    public void popNode(PNode node) {
        this.nodeStack.pop();
    }

    public PNode getPickedNode() {
        return (PNode)this.nodeStack.peek();
    }

    public PNode nextPickedNode() {
        PNode picked = this.getPickedNode();
        if (picked == this.topCamera) {
            return null;
        }
        if (this.excludedNodes == null) {
            this.excludedNodes = new HashMap();
        }
        this.excludedNodes.put(picked, picked);
        Object screenPickBounds = this.pickBoundsStack.get(0);
        this.pickBoundsStack = new PStack();
        this.nodeStack = new PStack();
        this.transformStack = new PStack();
        this.pickBoundsStack = new PStack();
        this.pickBoundsStack.push(screenPickBounds);
        this.topCamera.fullPick(this);
        if (this.getNodeStackReference().size() == 0) {
            this.pushNode(this.topCamera);
            this.pushTransform(this.topCamera.getTransformReference(false));
        }
        return this.getPickedNode();
    }

    public PCamera getTopCamera() {
        return this.topCamera;
    }

    public PCamera getBottomCamera() {
        if (this.bottomCamera == null) {
            this.bottomCamera = this.calculateBottomCamera();
        }
        return this.bottomCamera;
    }

    private PCamera calculateBottomCamera() {
        for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
            PNode each = (PNode)this.nodeStack.get(i);
            if (!(each instanceof PCamera)) continue;
            return (PCamera)each;
        }
        return null;
    }

    public PStack getNodeStackReference() {
        return this.nodeStack;
    }

    public double getScale() {
        PPickPath.PTS[0] = 0.0;
        PPickPath.PTS[1] = 0.0;
        PPickPath.PTS[2] = 1.0;
        PPickPath.PTS[3] = 0.0;
        int count = this.transformStack.size();
        for (int i = 0; i < count; ++i) {
            PAffineTransform each = ((PTuple)this.transformStack.get((int)i)).transform;
            if (each == null) continue;
            each.transform(PTS, 0, PTS, 0, 2);
        }
        return Point2D.distance(PTS[0], PTS[1], PTS[2], PTS[3]);
    }

    public void pushTransform(PAffineTransform transform) {
        this.transformStack.push(new PTuple(this.getPickedNode(), transform));
        if (transform != null) {
            Rectangle2D newPickBounds = (Rectangle2D)this.getPickBounds().clone();
            transform.inverseTransform(newPickBounds, newPickBounds);
            this.pickBoundsStack.push(newPickBounds);
        }
    }

    public void popTransform(PAffineTransform transform) {
        this.transformStack.pop();
        if (transform != null) {
            this.pickBoundsStack.pop();
        }
    }

    public PAffineTransform getPathTransformTo(PNode nodeOnPath) {
        PAffineTransform aTransform = new PAffineTransform();
        int count = this.transformStack.size();
        for (int i = 0; i < count; ++i) {
            PTuple each = (PTuple)this.transformStack.get(i);
            if (each.transform != null) {
                aTransform.concatenate(each.transform);
            }
            if (nodeOnPath != each.node) continue;
            return aTransform;
        }
        throw new RuntimeException("Node could not be found on pick path");
    }

    public void processEvent(PInputEvent event, int eventType) {
        event.setPath(this);
        for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
            PNode each = (PNode)this.nodeStack.get(i);
            EventListenerList list = each.getListenerList();
            if (list == null) continue;
            EventListener[] listeners = list.getListeners(class$edu$umd$cs$piccolo$event$PInputEventListener == null ? PPickPath.class$("edu.umd.cs.piccolo.event.PInputEventListener") : class$edu$umd$cs$piccolo$event$PInputEventListener);
            for (int j = 0; j < listeners.length; ++j) {
                PInputEventListener listener = (PInputEventListener)listeners[j];
                listener.processEvent(event, eventType);
                if (!event.isHandled()) continue;
                return;
            }
        }
    }

    public Point2D canvasToLocal(Point2D canvasPoint, PNode nodeOnPath) {
        return this.getPathTransformTo(nodeOnPath).inverseTransform(canvasPoint, canvasPoint);
    }

    public Dimension2D canvasToLocal(Dimension2D canvasDimension, PNode nodeOnPath) {
        return this.getPathTransformTo(nodeOnPath).inverseTransform(canvasDimension, canvasDimension);
    }

    public Rectangle2D canvasToLocal(Rectangle2D canvasRectangle, PNode nodeOnPath) {
        return this.getPathTransformTo(nodeOnPath).inverseTransform(canvasRectangle, canvasRectangle);
    }

    static {
        PTS = new double[4];
    }

    private static class PTuple {
        public PNode node;
        public PAffineTransform transform;

        public PTuple(PNode n, PAffineTransform t) {
            this.node = n;
            this.transform = t;
        }
    }
}

