/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class PObjectOutputStream
extends ObjectOutputStream {
    private boolean writingRoot;
    private final HashMap unconditionallyWritten = new HashMap();
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b) {
        }

        public void write(byte[] b, int off, int len) {
        }

        public void write(int b) {
        }
    };

    public static byte[] toByteArray(Object object) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PObjectOutputStream zout = new PObjectOutputStream(out);
        zout.writeObjectTree(object);
        return out.toByteArray();
    }

    public PObjectOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    public void writeObjectTree(Object object) throws IOException {
        this.writingRoot = true;
        this.recordUnconditionallyWritten(object);
        this.writeObject(object);
        this.writingRoot = false;
    }

    public void writeConditionalObject(Object object) throws IOException {
        if (!this.writingRoot) {
            throw new RuntimeException("writeConditionalObject() may only be called when a root object has been written.");
        }
        if (this.unconditionallyWritten.containsKey(object)) {
            this.writeObject(object);
        } else {
            this.writeObject(null);
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.unconditionallyWritten.clear();
    }

    protected void recordUnconditionallyWritten(Object aRoot) throws IOException {
        class ZMarkObjectOutputStream
        extends PObjectOutputStream {
            public ZMarkObjectOutputStream() throws IOException {
                super(NULL_OUTPUT_STREAM);
                this.enableReplaceObject(true);
            }

            public Object replaceObject(Object object) {
                PObjectOutputStream.this.unconditionallyWritten.put(object, Boolean.TRUE);
                return object;
            }

            public void writeConditionalObject(Object object) throws IOException {
            }
        }
        new ZMarkObjectOutputStream().writeObject(aRoot);
    }
}

