/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.OutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.bouncycastle.extensions.OpenPGPCertificateExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/util/OpenPGPCertificateUtil;", "", "()V", "Companion", "pgpainless-core"})
public final class OpenPGPCertificateUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private OpenPGPCertificateUtil() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void encode(@NotNull Collection<? extends OpenPGPCertificate> certs, @NotNull OutputStream outputStream, @NotNull PacketFormat packetFormat) {
        Companion.encode(certs, outputStream, packetFormat);
    }

    @JvmStatic
    @JvmOverloads
    public static final void armor(@NotNull Collection<? extends OpenPGPCertificate> certs, @NotNull OutputStream outputStream, @NotNull PacketFormat packetFormat) {
        Companion.armor(certs, outputStream, packetFormat);
    }

    @JvmStatic
    @JvmOverloads
    public static final void encode(@NotNull Collection<? extends OpenPGPCertificate> certs, @NotNull OutputStream outputStream) {
        Companion.encode(certs, outputStream);
    }

    @JvmStatic
    @JvmOverloads
    public static final void armor(@NotNull Collection<? extends OpenPGPCertificate> certs, @NotNull OutputStream outputStream) {
        Companion.armor(certs, outputStream);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J(\u0010\f\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lorg/pgpainless/util/OpenPGPCertificateUtil$Companion;", "", "()V", "armor", "", "certs", "", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "outputStream", "Ljava/io/OutputStream;", "packetFormat", "Lorg/bouncycastle/bcpg/PacketFormat;", "encode", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void encode(@NotNull Collection<? extends OpenPGPCertificate> certs, @NotNull OutputStream outputStream, @NotNull PacketFormat packetFormat) {
            Intrinsics.checkNotNullParameter(certs, (String)"certs");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)packetFormat, (String)"packetFormat");
            for (OpenPGPCertificate openPGPCertificate : certs) {
                OpenPGPCertificateExtensionsKt.encode(openPGPCertificate, outputStream, packetFormat);
            }
        }

        public static /* synthetic */ void encode$default(Companion companion, Collection collection, OutputStream outputStream, PacketFormat packetFormat, int n, Object object) {
            if ((n & 4) != 0) {
                packetFormat = PacketFormat.ROUNDTRIP;
            }
            companion.encode(collection, outputStream, packetFormat);
        }

        @JvmStatic
        @JvmOverloads
        public final void armor(@NotNull Collection<? extends OpenPGPCertificate> certs, @NotNull OutputStream outputStream, @NotNull PacketFormat packetFormat) {
            Intrinsics.checkNotNullParameter(certs, (String)"certs");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)packetFormat, (String)"packetFormat");
            if (certs.size() == 1) {
                OpenPGPCertificateExtensionsKt.asciiArmor(certs.iterator().next(), outputStream, packetFormat);
            } else {
                ArmoredOutputStream aOut = new ArmoredOutputStream(outputStream);
                for (OpenPGPCertificate openPGPCertificate : certs) {
                    OpenPGPCertificateExtensionsKt.encode(openPGPCertificate, (OutputStream)aOut, packetFormat);
                }
                aOut.close();
            }
        }

        public static /* synthetic */ void armor$default(Companion companion, Collection collection, OutputStream outputStream, PacketFormat packetFormat, int n, Object object) {
            if ((n & 4) != 0) {
                packetFormat = PacketFormat.ROUNDTRIP;
            }
            companion.armor(collection, outputStream, packetFormat);
        }

        @JvmStatic
        @JvmOverloads
        public final void encode(@NotNull Collection<? extends OpenPGPCertificate> certs, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter(certs, (String)"certs");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            org.pgpainless.util.OpenPGPCertificateUtil$Companion.encode$default(this, certs, outputStream, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void armor(@NotNull Collection<? extends OpenPGPCertificate> certs, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter(certs, (String)"certs");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            org.pgpainless.util.OpenPGPCertificateUtil$Companion.armor$default(this, certs, outputStream, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

