/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001a\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u001d\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020!R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/pgpainless/signature/builder/SubkeyBindingSignatureBuilder;", "Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "signingKey", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/PGPainless;)V", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "(Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/algorithm/HashAlgorithm;Lorg/pgpainless/PGPainless;)V", "oldSubkeyBinding", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/bouncycastle/openpgp/PGPSignature;Lorg/pgpainless/PGPainless;)V", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "getHashedSubpackets", "()Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "Lorg/pgpainless/algorithm/SignatureType;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "unhashedSubpackets", "getUnhashedSubpackets", "applyCallback", "callback", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets$Callback;", "build", "subkey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentSignature;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "pgpainless-core"})
public final class SubkeyBindingSignatureBuilder
extends AbstractSignatureBuilder<SubkeyBindingSignatureBuilder> {
    @NotNull
    private final SelfSignatureSubpackets hashedSubpackets;
    @NotNull
    private final SelfSignatureSubpackets unhashedSubpackets;

    @Override
    @NotNull
    protected Predicate<SignatureType> getSignatureTypePredicate() {
        return SubkeyBindingSignatureBuilder::_get_signatureTypePredicate_$lambda$0;
    }

    public SubkeyBindingSignatureBuilder(@NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPainless api) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        super(SignatureType.SUBKEY_BINDING, signingKey, protector, api);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public SubkeyBindingSignatureBuilder(@NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull HashAlgorithm hashAlgorithm, @NotNull PGPainless api) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        PGPPublicKey pGPPublicKey = signingKey.getPublicKey().getPGPPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
        super(SignatureType.SUBKEY_BINDING, signingKey, protector, hashAlgorithm, SignatureSubpackets.Companion.createHashedSubpackets(pGPPublicKey), SignatureSubpackets.Companion.createEmptySubpackets(), api);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    /*
     * WARNING - void declaration
     */
    public SubkeyBindingSignatureBuilder(@NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPSignature oldSubkeyBinding, @NotNull PGPainless api) throws PGPException {
        void it;
        PGPSignature pGPSignature;
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)oldSubkeyBinding, (String)"oldSubkeyBinding");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        PGPSignature pGPSignature2 = pGPSignature = oldSubkeyBinding;
        SecretKeyRingProtector secretKeyRingProtector = protector;
        OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = signingKey;
        SubkeyBindingSignatureBuilder subkeyBindingSignatureBuilder = this;
        boolean bl = false;
        if (!(it.getSignatureType() == SignatureType.SUBKEY_BINDING.getCode())) {
            boolean bl2 = false;
            String string = "Invalid signature type.";
            throw new IllegalArgumentException(string.toString());
        }
        Unit unit = Unit.INSTANCE;
        super(openPGPSecretKey, secretKeyRingProtector, pGPSignature, api);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    @NotNull
    public final SelfSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    @NotNull
    public final SelfSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    @NotNull
    public final SubkeyBindingSignatureBuilder applyCallback(@Nullable SelfSignatureSubpackets.Callback callback2) {
        SubkeyBindingSignatureBuilder subkeyBindingSignatureBuilder;
        block0: {
            SubkeyBindingSignatureBuilder $this$applyCallback_u24lambda_u244 = subkeyBindingSignatureBuilder = this;
            boolean bl = false;
            SelfSignatureSubpackets.Callback callback3 = callback2;
            if (callback3 == null) break block0;
            SelfSignatureSubpackets.Callback it = callback3;
            boolean bl2 = false;
            it.modifyHashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u244.hashedSubpackets);
            it.modifyUnhashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u244.unhashedSubpackets);
        }
        return subkeyBindingSignatureBuilder;
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPPublicKey subkey) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)subkey, (String)"subkey");
        PGPSignature pGPSignature = this.buildAndInitSignatureGenerator().generateCertification(this.getSigningKey().getPublicKey().getPGPPublicKey(), subkey);
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"generateCertification(...)");
        return pGPSignature;
    }

    @NotNull
    public final OpenPGPCertificate.OpenPGPComponentSignature build(@NotNull OpenPGPCertificate.OpenPGPComponentKey subkey) {
        Intrinsics.checkNotNullParameter((Object)subkey, (String)"subkey");
        PGPPublicKey pGPPublicKey = subkey.getPGPPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
        return new OpenPGPCertificate.OpenPGPComponentSignature(this.build(pGPPublicKey), this.getSigningKey().getPublicKey(), (OpenPGPCertificate.OpenPGPCertificateComponent)subkey);
    }

    private static final boolean _get_signatureTypePredicate_$lambda$0(SignatureType it) {
        return it == SignatureType.SUBKEY_BINDING;
    }
}

