/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.RevocationSignatureSubpackets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u0018\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u001fJ\u0016\u0010\u0018\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0018\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/pgpainless/signature/builder/RevocationSignatureBuilder;", "Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "signatureType", "Lorg/pgpainless/algorithm/SignatureType;", "signingKey", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/algorithm/SignatureType;Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/PGPainless;)V", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/RevocationSignatureSubpackets;", "getHashedSubpackets", "()Lorg/pgpainless/signature/subpackets/RevocationSignatureSubpackets;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "unhashedSubpackets", "getUnhashedSubpackets", "applyCallback", "callback", "Lorg/pgpainless/signature/subpackets/RevocationSignatureSubpackets$Callback;", "build", "Lorg/bouncycastle/openpgp/PGPSignature;", "revokeeUserId", "", "revokeeKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "Lorg/bouncycastle/openpgp/api/OpenPGPSignature;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentSignature;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPUserId;", "pgpainless-core"})
public final class RevocationSignatureBuilder
extends AbstractSignatureBuilder<RevocationSignatureBuilder> {
    @NotNull
    private final RevocationSignatureSubpackets hashedSubpackets;
    @NotNull
    private final RevocationSignatureSubpackets unhashedSubpackets;

    public RevocationSignatureBuilder(@NotNull SignatureType signatureType, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPainless api) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        super(signatureType, signingKey, protector, api);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
        this.hashedSubpackets.setRevocable(false);
    }

    @Override
    @NotNull
    protected Predicate<SignatureType> getSignatureTypePredicate() {
        return RevocationSignatureBuilder::_get_signatureTypePredicate_$lambda$0;
    }

    @NotNull
    public final RevocationSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    @NotNull
    public final RevocationSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    @NotNull
    public final RevocationSignatureBuilder applyCallback(@Nullable RevocationSignatureSubpackets.Callback callback2) {
        RevocationSignatureBuilder revocationSignatureBuilder;
        block0: {
            RevocationSignatureBuilder $this$applyCallback_u24lambda_u242 = revocationSignatureBuilder = this;
            boolean bl = false;
            RevocationSignatureSubpackets.Callback callback3 = callback2;
            if (callback3 == null) break block0;
            RevocationSignatureSubpackets.Callback it = callback3;
            boolean bl2 = false;
            it.modifyHashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.hashedSubpackets);
            it.modifyUnhashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.unhashedSubpackets);
        }
        return revocationSignatureBuilder;
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPPublicKey revokeeKey) throws PGPException {
        PGPSignature pGPSignature;
        Intrinsics.checkNotNullParameter((Object)revokeeKey, (String)"revokeeKey");
        PGPSignatureGenerator it = this.buildAndInitSignatureGenerator();
        boolean bl = false;
        if (this.get_signatureType() == SignatureType.KEY_REVOCATION) {
            if (!revokeeKey.isMasterKey()) {
                boolean bl2 = false;
                String string = "Signature type is KEY_REVOCATION, but provided revokee does not appear to be a primary key.";
                throw new IllegalArgumentException(string.toString());
            }
            pGPSignature = it.generateCertification(revokeeKey);
        } else {
            pGPSignature = it.generateCertification(this.getSigningKey().getPublicKey().getPGPPublicKey(), revokeeKey);
        }
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"let(...)");
        return pGPSignature;
    }

    @NotNull
    public final OpenPGPSignature build(@NotNull OpenPGPCertificate.OpenPGPComponentKey revokeeKey) {
        Intrinsics.checkNotNullParameter((Object)revokeeKey, (String)"revokeeKey");
        PGPPublicKey pGPPublicKey = revokeeKey.getPGPPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
        return (OpenPGPSignature)new OpenPGPCertificate.OpenPGPComponentSignature(this.build(pGPPublicKey), this.getSigningKey().getPublicKey(), (OpenPGPCertificate.OpenPGPCertificateComponent)revokeeKey);
    }

    @NotNull
    public final PGPSignature build(@NotNull CharSequence revokeeUserId) throws PGPException {
        PGPSignatureGenerator pGPSignatureGenerator;
        Intrinsics.checkNotNullParameter((Object)revokeeUserId, (String)"revokeeUserId");
        PGPSignatureGenerator it = pGPSignatureGenerator = this.buildAndInitSignatureGenerator();
        boolean bl = false;
        if (!(this.get_signatureType() == SignatureType.CERTIFICATION_REVOCATION)) {
            boolean bl2 = false;
            String string = "Signature type is != CERTIFICATION_REVOCATION.";
            throw new IllegalArgumentException(string.toString());
        }
        PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(((Object)revokeeUserId).toString(), this.getSigningKey().getPublicKey().getPGPPublicKey());
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"generateCertification(...)");
        return pGPSignature;
    }

    @NotNull
    public final OpenPGPCertificate.OpenPGPComponentSignature build(@NotNull OpenPGPCertificate.OpenPGPUserId revokeeUserId) {
        Intrinsics.checkNotNullParameter((Object)revokeeUserId, (String)"revokeeUserId");
        String string = revokeeUserId.getUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserId(...)");
        return new OpenPGPCertificate.OpenPGPComponentSignature(this.build(string), this.getSigningKey().getPublicKey(), (OpenPGPCertificate.OpenPGPCertificateComponent)revokeeUserId);
    }

    @NotNull
    public final OpenPGPCertificate.OpenPGPComponentSignature build(@NotNull OpenPGPCertificate.OpenPGPComponentKey revokeeKey, @NotNull CharSequence revokeeUserId) {
        PGPSignatureGenerator pGPSignatureGenerator;
        Intrinsics.checkNotNullParameter((Object)revokeeKey, (String)"revokeeKey");
        Intrinsics.checkNotNullParameter((Object)revokeeUserId, (String)"revokeeUserId");
        PGPSignatureGenerator it = pGPSignatureGenerator = this.buildAndInitSignatureGenerator();
        boolean bl = false;
        if (!(this.get_signatureType() == SignatureType.CERTIFICATION_REVOCATION)) {
            boolean bl2 = false;
            String string = "Signature type is != CERTIFICATION_REVOCATION.";
            throw new IllegalArgumentException(string.toString());
        }
        OpenPGPCertificate.OpenPGPCertificateComponent openPGPCertificateComponent = (OpenPGPCertificate.OpenPGPCertificateComponent)revokeeKey.getCertificate().getUserId(((Object)revokeeUserId).toString());
        OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey = this.getSigningKey().getPublicKey();
        PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(((Object)revokeeUserId).toString(), revokeeKey.getPGPPublicKey());
        return new OpenPGPCertificate.OpenPGPComponentSignature(pGPSignature, openPGPComponentKey, openPGPCertificateComponent);
    }

    private static final boolean _get_signatureTypePredicate_$lambda$0(SignatureType it) {
        SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.KEY_REVOCATION, SignatureType.SUBKEY_REVOCATION, SignatureType.CERTIFICATION_REVOCATION};
        return CollectionsKt.listOf((Object[])signatureTypeArray).contains((Object)it);
    }
}

