/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bouncycastle.openpgp.api.EncryptedDataPacketType;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.AEADAlgorithm;
import org.pgpainless.algorithm.AlgorithmSuite;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.policy.Policy;
import org.pgpainless.util.DateUtil;
import org.pgpainless.util.NotationRegistry;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 ?2\u00020\u0001:\b>?@ABCDEBW\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013BW\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0017B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001aR\u001a\u0010\u0016\u001a\u00020\u00158FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b6\u0010\u0018\u001a\u0004\b7\u00108R\u001a\u0010\u0014\u001a\u00020\u00158FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b9\u0010\u0018\u001a\u0004\b:\u00108\u00a8\u0006F"}, d2={"Lorg/pgpainless/policy/Policy;", "", "certificationSignatureHashAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;", "revocationSignatureHashAlgorithmPolicy", "dataSignatureHashAlgorithmPolicy", "messageEncryptionMechanismPolicy", "Lorg/pgpainless/policy/Policy$MessageEncryptionMechanismPolicy;", "messageDecryptionMechanismPolicy", "compressionAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$CompressionAlgorithmPolicy;", "publicKeyAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$PublicKeyAlgorithmPolicy;", "keyProtectionSettings", "Lorg/pgpainless/key/protection/KeyRingProtectionSettings;", "notationRegistry", "Lorg/pgpainless/util/NotationRegistry;", "keyGenerationAlgorithmSuite", "Lorg/pgpainless/algorithm/AlgorithmSuite;", "(Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;Lorg/pgpainless/policy/Policy$MessageEncryptionMechanismPolicy;Lorg/pgpainless/policy/Policy$MessageEncryptionMechanismPolicy;Lorg/pgpainless/policy/Policy$CompressionAlgorithmPolicy;Lorg/pgpainless/policy/Policy$PublicKeyAlgorithmPolicy;Lorg/pgpainless/key/protection/KeyRingProtectionSettings;Lorg/pgpainless/util/NotationRegistry;Lorg/pgpainless/algorithm/AlgorithmSuite;)V", "symmetricKeyEncryptionAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;", "symmetricKeyDecryptionAlgorithmPolicy", "(Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;Lorg/pgpainless/policy/Policy$CompressionAlgorithmPolicy;Lorg/pgpainless/policy/Policy$PublicKeyAlgorithmPolicy;Lorg/pgpainless/key/protection/KeyRingProtectionSettings;Lorg/pgpainless/util/NotationRegistry;Lorg/pgpainless/algorithm/AlgorithmSuite;)V", "()V", "getCertificationSignatureHashAlgorithmPolicy", "()Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;", "getCompressionAlgorithmPolicy", "()Lorg/pgpainless/policy/Policy$CompressionAlgorithmPolicy;", "getDataSignatureHashAlgorithmPolicy", "enableKeyParameterValidation", "", "getEnableKeyParameterValidation", "()Z", "setEnableKeyParameterValidation", "(Z)V", "featurePolicy", "Lorg/pgpainless/policy/Policy$FeaturePolicy;", "getFeaturePolicy", "()Lorg/pgpainless/policy/Policy$FeaturePolicy;", "getKeyGenerationAlgorithmSuite", "()Lorg/pgpainless/algorithm/AlgorithmSuite;", "getKeyProtectionSettings", "()Lorg/pgpainless/key/protection/KeyRingProtectionSettings;", "messageDecryptionAlgorithmPolicy", "getMessageDecryptionAlgorithmPolicy", "()Lorg/pgpainless/policy/Policy$MessageEncryptionMechanismPolicy;", "messageEncryptionAlgorithmPolicy", "getMessageEncryptionAlgorithmPolicy", "getNotationRegistry", "()Lorg/pgpainless/util/NotationRegistry;", "getPublicKeyAlgorithmPolicy", "()Lorg/pgpainless/policy/Policy$PublicKeyAlgorithmPolicy;", "getRevocationSignatureHashAlgorithmPolicy", "getSymmetricKeyDecryptionAlgorithmPolicy$annotations", "getSymmetricKeyDecryptionAlgorithmPolicy", "()Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;", "getSymmetricKeyEncryptionAlgorithmPolicy$annotations", "getSymmetricKeyEncryptionAlgorithmPolicy", "copy", "Lorg/pgpainless/policy/Policy$Builder;", "isEnableKeyParameterValidation", "Builder", "Companion", "CompressionAlgorithmPolicy", "FeaturePolicy", "HashAlgorithmPolicy", "MessageEncryptionMechanismPolicy", "PublicKeyAlgorithmPolicy", "SymmetricKeyAlgorithmPolicy", "pgpainless-core"})
public final class Policy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashAlgorithmPolicy certificationSignatureHashAlgorithmPolicy;
    @NotNull
    private final HashAlgorithmPolicy revocationSignatureHashAlgorithmPolicy;
    @NotNull
    private final HashAlgorithmPolicy dataSignatureHashAlgorithmPolicy;
    @NotNull
    private final MessageEncryptionMechanismPolicy messageEncryptionAlgorithmPolicy;
    @NotNull
    private final MessageEncryptionMechanismPolicy messageDecryptionAlgorithmPolicy;
    @NotNull
    private final CompressionAlgorithmPolicy compressionAlgorithmPolicy;
    @NotNull
    private final PublicKeyAlgorithmPolicy publicKeyAlgorithmPolicy;
    @NotNull
    private final FeaturePolicy featurePolicy;
    @NotNull
    private final KeyRingProtectionSettings keyProtectionSettings;
    @NotNull
    private final NotationRegistry notationRegistry;
    @NotNull
    private final AlgorithmSuite keyGenerationAlgorithmSuite;
    private boolean enableKeyParameterValidation;

    @NotNull
    public final HashAlgorithmPolicy getCertificationSignatureHashAlgorithmPolicy() {
        return this.certificationSignatureHashAlgorithmPolicy;
    }

    @NotNull
    public final HashAlgorithmPolicy getRevocationSignatureHashAlgorithmPolicy() {
        return this.revocationSignatureHashAlgorithmPolicy;
    }

    @NotNull
    public final HashAlgorithmPolicy getDataSignatureHashAlgorithmPolicy() {
        return this.dataSignatureHashAlgorithmPolicy;
    }

    @NotNull
    public final MessageEncryptionMechanismPolicy getMessageEncryptionAlgorithmPolicy() {
        return this.messageEncryptionAlgorithmPolicy;
    }

    @NotNull
    public final MessageEncryptionMechanismPolicy getMessageDecryptionAlgorithmPolicy() {
        return this.messageDecryptionAlgorithmPolicy;
    }

    @NotNull
    public final CompressionAlgorithmPolicy getCompressionAlgorithmPolicy() {
        return this.compressionAlgorithmPolicy;
    }

    @NotNull
    public final PublicKeyAlgorithmPolicy getPublicKeyAlgorithmPolicy() {
        return this.publicKeyAlgorithmPolicy;
    }

    @NotNull
    public final FeaturePolicy getFeaturePolicy() {
        return this.featurePolicy;
    }

    @NotNull
    public final KeyRingProtectionSettings getKeyProtectionSettings() {
        return this.keyProtectionSettings;
    }

    @NotNull
    public final NotationRegistry getNotationRegistry() {
        return this.notationRegistry;
    }

    @NotNull
    public final AlgorithmSuite getKeyGenerationAlgorithmSuite() {
        return this.keyGenerationAlgorithmSuite;
    }

    public Policy(@NotNull HashAlgorithmPolicy certificationSignatureHashAlgorithmPolicy, @NotNull HashAlgorithmPolicy revocationSignatureHashAlgorithmPolicy, @NotNull HashAlgorithmPolicy dataSignatureHashAlgorithmPolicy, @NotNull MessageEncryptionMechanismPolicy messageEncryptionMechanismPolicy, @NotNull MessageEncryptionMechanismPolicy messageDecryptionMechanismPolicy, @NotNull CompressionAlgorithmPolicy compressionAlgorithmPolicy, @NotNull PublicKeyAlgorithmPolicy publicKeyAlgorithmPolicy, @NotNull KeyRingProtectionSettings keyProtectionSettings, @NotNull NotationRegistry notationRegistry, @NotNull AlgorithmSuite keyGenerationAlgorithmSuite) {
        Intrinsics.checkNotNullParameter((Object)certificationSignatureHashAlgorithmPolicy, (String)"certificationSignatureHashAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)revocationSignatureHashAlgorithmPolicy, (String)"revocationSignatureHashAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)dataSignatureHashAlgorithmPolicy, (String)"dataSignatureHashAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)messageEncryptionMechanismPolicy, (String)"messageEncryptionMechanismPolicy");
        Intrinsics.checkNotNullParameter((Object)messageDecryptionMechanismPolicy, (String)"messageDecryptionMechanismPolicy");
        Intrinsics.checkNotNullParameter((Object)compressionAlgorithmPolicy, (String)"compressionAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)publicKeyAlgorithmPolicy, (String)"publicKeyAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)keyProtectionSettings, (String)"keyProtectionSettings");
        Intrinsics.checkNotNullParameter((Object)notationRegistry, (String)"notationRegistry");
        Intrinsics.checkNotNullParameter((Object)keyGenerationAlgorithmSuite, (String)"keyGenerationAlgorithmSuite");
        this.featurePolicy = FeaturePolicy.Companion.defaultFeaturePolicy();
        this.certificationSignatureHashAlgorithmPolicy = certificationSignatureHashAlgorithmPolicy;
        this.revocationSignatureHashAlgorithmPolicy = revocationSignatureHashAlgorithmPolicy;
        this.dataSignatureHashAlgorithmPolicy = dataSignatureHashAlgorithmPolicy;
        this.messageEncryptionAlgorithmPolicy = messageEncryptionMechanismPolicy;
        this.messageDecryptionAlgorithmPolicy = messageDecryptionMechanismPolicy;
        this.compressionAlgorithmPolicy = compressionAlgorithmPolicy;
        this.publicKeyAlgorithmPolicy = publicKeyAlgorithmPolicy;
        this.keyProtectionSettings = keyProtectionSettings;
        this.notationRegistry = notationRegistry;
        this.keyGenerationAlgorithmSuite = keyGenerationAlgorithmSuite;
    }

    @Deprecated(message="Constructors receiving SymmetricKeyAlgorithmPolicy objects are deprecated in favor of ones receiving MessageEncryptionMechanismPolicy objects.")
    public Policy(@NotNull HashAlgorithmPolicy certificationSignatureHashAlgorithmPolicy, @NotNull HashAlgorithmPolicy revocationSignatureHashAlgorithmPolicy, @NotNull HashAlgorithmPolicy dataSignatureHashAlgorithmPolicy, @NotNull SymmetricKeyAlgorithmPolicy symmetricKeyEncryptionAlgorithmPolicy, @NotNull SymmetricKeyAlgorithmPolicy symmetricKeyDecryptionAlgorithmPolicy, @NotNull CompressionAlgorithmPolicy compressionAlgorithmPolicy, @NotNull PublicKeyAlgorithmPolicy publicKeyAlgorithmPolicy, @NotNull KeyRingProtectionSettings keyProtectionSettings, @NotNull NotationRegistry notationRegistry, @NotNull AlgorithmSuite keyGenerationAlgorithmSuite) {
        Intrinsics.checkNotNullParameter((Object)certificationSignatureHashAlgorithmPolicy, (String)"certificationSignatureHashAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)revocationSignatureHashAlgorithmPolicy, (String)"revocationSignatureHashAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)dataSignatureHashAlgorithmPolicy, (String)"dataSignatureHashAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)symmetricKeyEncryptionAlgorithmPolicy, (String)"symmetricKeyEncryptionAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)symmetricKeyDecryptionAlgorithmPolicy, (String)"symmetricKeyDecryptionAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)compressionAlgorithmPolicy, (String)"compressionAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)publicKeyAlgorithmPolicy, (String)"publicKeyAlgorithmPolicy");
        Intrinsics.checkNotNullParameter((Object)keyProtectionSettings, (String)"keyProtectionSettings");
        Intrinsics.checkNotNullParameter((Object)notationRegistry, (String)"notationRegistry");
        Intrinsics.checkNotNullParameter((Object)keyGenerationAlgorithmSuite, (String)"keyGenerationAlgorithmSuite");
        this.featurePolicy = FeaturePolicy.Companion.defaultFeaturePolicy();
        this.certificationSignatureHashAlgorithmPolicy = certificationSignatureHashAlgorithmPolicy;
        this.revocationSignatureHashAlgorithmPolicy = revocationSignatureHashAlgorithmPolicy;
        this.dataSignatureHashAlgorithmPolicy = dataSignatureHashAlgorithmPolicy;
        this.messageEncryptionAlgorithmPolicy = MessageEncryptionMechanismPolicy.Companion.rfc4880Plus9580PlusLibrePGP(symmetricKeyEncryptionAlgorithmPolicy);
        this.messageDecryptionAlgorithmPolicy = MessageEncryptionMechanismPolicy.Companion.rfc4880Plus9580PlusLibrePGP(symmetricKeyDecryptionAlgorithmPolicy);
        this.compressionAlgorithmPolicy = compressionAlgorithmPolicy;
        this.publicKeyAlgorithmPolicy = publicKeyAlgorithmPolicy;
        this.keyProtectionSettings = keyProtectionSettings;
        this.notationRegistry = notationRegistry;
        this.keyGenerationAlgorithmSuite = keyGenerationAlgorithmSuite;
    }

    @Deprecated(message="Constructors receiving SymmetricKeyAlgorithmPolicy objects are deprecated in favor of ones receiving MessageEncryptionMechanismPolicy objects.")
    public Policy() {
        this(HashAlgorithmPolicy.Companion.smartCertificationSignatureHashAlgorithmPolicy(), HashAlgorithmPolicy.Companion.smartCertificationSignatureHashAlgorithmPolicy(), HashAlgorithmPolicy.Companion.smartDataSignatureHashAlgorithmPolicy(), SymmetricKeyAlgorithmPolicy.Companion.symmetricKeyEncryptionPolicy2022(), SymmetricKeyAlgorithmPolicy.Companion.symmetricKeyDecryptionPolicy2022(), CompressionAlgorithmPolicy.Companion.anyCompressionAlgorithmPolicy(), PublicKeyAlgorithmPolicy.Companion.rfc9580PublicKeyAlgorithmPolicy(), KeyRingProtectionSettings.Companion.secureDefaultSettings(), new NotationRegistry(null, 1, null), AlgorithmSuite.Companion.getDefaultAlgorithmSuite());
    }

    @NotNull
    public final SymmetricKeyAlgorithmPolicy getSymmetricKeyEncryptionAlgorithmPolicy() {
        return this.messageEncryptionAlgorithmPolicy.getSymmetricAlgorithmPolicy();
    }

    @Deprecated(message="Deprecated in favor of messageEncryptionAlgorithmPolicy")
    public static /* synthetic */ void getSymmetricKeyEncryptionAlgorithmPolicy$annotations() {
    }

    @NotNull
    public final SymmetricKeyAlgorithmPolicy getSymmetricKeyDecryptionAlgorithmPolicy() {
        return this.messageDecryptionAlgorithmPolicy.getSymmetricAlgorithmPolicy();
    }

    @Deprecated(message="Deprecated in favor of messageDecryptionAlgorithmPolicy")
    public static /* synthetic */ void getSymmetricKeyDecryptionAlgorithmPolicy$annotations() {
    }

    public final boolean getEnableKeyParameterValidation() {
        return this.enableKeyParameterValidation;
    }

    public final void setEnableKeyParameterValidation(boolean bl) {
        this.enableKeyParameterValidation = bl;
    }

    @NotNull
    public final Builder copy() {
        return new Builder(this);
    }

    public final boolean isEnableKeyParameterValidation() {
        return this.enableKeyParameterValidation;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020%H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/pgpainless/policy/Policy$Builder;", "", "origin", "Lorg/pgpainless/policy/Policy;", "(Lorg/pgpainless/policy/Policy;)V", "certificationSignatureHashAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;", "compressionAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$CompressionAlgorithmPolicy;", "dataSignatureHashAlgorithmPolicy", "keyGenerationAlgorithmSuite", "Lorg/pgpainless/algorithm/AlgorithmSuite;", "keyProtectionSettings", "Lorg/pgpainless/key/protection/KeyRingProtectionSettings;", "messageDecryptionMechanismPolicy", "Lorg/pgpainless/policy/Policy$MessageEncryptionMechanismPolicy;", "messageEncryptionMechanismPolicy", "notationRegistry", "Lorg/pgpainless/util/NotationRegistry;", "publicKeyAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$PublicKeyAlgorithmPolicy;", "revocationSignatureHashAlgorithmPolicy", "build", "withCertificationSignatureHashAlgorithmPolicy", "withCompressionAlgorithmPolicy", "withDataSignatureHashAlgorithmPolicy", "withKeyGenerationAlgorithmSuite", "withKeyProtectionSettings", "withMessageDecryptionAlgorithmPolicy", "decryptionMechanismPolicy", "withMessageEncryptionAlgorithmPolicy", "encryptionMechanismPolicy", "withNotationRegistry", "withPublicKeyAlgorithmPolicy", "withRevocationSignatureHashAlgorithmPolicy", "withSymmetricKeyDecryptionAlgorithmPolicy", "symmetricKeyDecryptionAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;", "withSymmetricKeyEncryptionAlgorithmPolicy", "symmetricKeyEncryptionAlgorithmPolicy", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Policy.kt\norg/pgpainless/policy/Policy$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,783:1\n1#2:784\n*E\n"})
    public static final class Builder {
        @NotNull
        private final Policy origin;
        @NotNull
        private HashAlgorithmPolicy certificationSignatureHashAlgorithmPolicy;
        @NotNull
        private HashAlgorithmPolicy revocationSignatureHashAlgorithmPolicy;
        @NotNull
        private HashAlgorithmPolicy dataSignatureHashAlgorithmPolicy;
        @NotNull
        private MessageEncryptionMechanismPolicy messageEncryptionMechanismPolicy;
        @NotNull
        private MessageEncryptionMechanismPolicy messageDecryptionMechanismPolicy;
        @NotNull
        private CompressionAlgorithmPolicy compressionAlgorithmPolicy;
        @NotNull
        private PublicKeyAlgorithmPolicy publicKeyAlgorithmPolicy;
        @NotNull
        private KeyRingProtectionSettings keyProtectionSettings;
        @NotNull
        private NotationRegistry notationRegistry;
        @NotNull
        private AlgorithmSuite keyGenerationAlgorithmSuite;

        public Builder(@NotNull Policy origin) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            this.origin = origin;
            this.certificationSignatureHashAlgorithmPolicy = this.origin.getCertificationSignatureHashAlgorithmPolicy();
            this.revocationSignatureHashAlgorithmPolicy = this.origin.getRevocationSignatureHashAlgorithmPolicy();
            this.dataSignatureHashAlgorithmPolicy = this.origin.getDataSignatureHashAlgorithmPolicy();
            this.messageEncryptionMechanismPolicy = this.origin.getMessageEncryptionAlgorithmPolicy();
            this.messageDecryptionMechanismPolicy = this.origin.getMessageDecryptionAlgorithmPolicy();
            this.compressionAlgorithmPolicy = this.origin.getCompressionAlgorithmPolicy();
            this.publicKeyAlgorithmPolicy = this.origin.getPublicKeyAlgorithmPolicy();
            this.keyProtectionSettings = this.origin.getKeyProtectionSettings();
            this.notationRegistry = this.origin.getNotationRegistry();
            this.keyGenerationAlgorithmSuite = this.origin.getKeyGenerationAlgorithmSuite();
        }

        @NotNull
        public final Builder withCertificationSignatureHashAlgorithmPolicy(@NotNull HashAlgorithmPolicy certificationSignatureHashAlgorithmPolicy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)certificationSignatureHashAlgorithmPolicy, (String)"certificationSignatureHashAlgorithmPolicy");
            Builder $this$withCertificationSignatureHashAlgorithmPolicy_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$withCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.certificationSignatureHashAlgorithmPolicy = certificationSignatureHashAlgorithmPolicy;
            return builder;
        }

        @NotNull
        public final Builder withRevocationSignatureHashAlgorithmPolicy(@NotNull HashAlgorithmPolicy revocationSignatureHashAlgorithmPolicy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)revocationSignatureHashAlgorithmPolicy, (String)"revocationSignatureHashAlgorithmPolicy");
            Builder $this$withRevocationSignatureHashAlgorithmPolicy_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$withRevocationSignatureHashAlgorithmPolicy_u24lambda_u241.revocationSignatureHashAlgorithmPolicy = revocationSignatureHashAlgorithmPolicy;
            return builder;
        }

        @NotNull
        public final Builder withDataSignatureHashAlgorithmPolicy(@NotNull HashAlgorithmPolicy dataSignatureHashAlgorithmPolicy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)dataSignatureHashAlgorithmPolicy, (String)"dataSignatureHashAlgorithmPolicy");
            Builder $this$withDataSignatureHashAlgorithmPolicy_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$withDataSignatureHashAlgorithmPolicy_u24lambda_u242.dataSignatureHashAlgorithmPolicy = dataSignatureHashAlgorithmPolicy;
            return builder;
        }

        @Deprecated(message="Usage of SymmetricKeyAlgorithmPolicy is deprecated in favor of MessageEncryptionMechanismPolicy.")
        @NotNull
        public final Builder withSymmetricKeyEncryptionAlgorithmPolicy(@NotNull SymmetricKeyAlgorithmPolicy symmetricKeyEncryptionAlgorithmPolicy) {
            Intrinsics.checkNotNullParameter((Object)symmetricKeyEncryptionAlgorithmPolicy, (String)"symmetricKeyEncryptionAlgorithmPolicy");
            return this.withMessageEncryptionAlgorithmPolicy(MessageEncryptionMechanismPolicy.Companion.rfc4880Plus9580PlusLibrePGP(symmetricKeyEncryptionAlgorithmPolicy));
        }

        @Deprecated(message="Usage of SymmetricKeyAlgorithmPolicy is deprecated in favor of MessageEncryptionMechanismPolicy.")
        @NotNull
        public final Builder withSymmetricKeyDecryptionAlgorithmPolicy(@NotNull SymmetricKeyAlgorithmPolicy symmetricKeyDecryptionAlgorithmPolicy) {
            Intrinsics.checkNotNullParameter((Object)symmetricKeyDecryptionAlgorithmPolicy, (String)"symmetricKeyDecryptionAlgorithmPolicy");
            return this.withMessageDecryptionAlgorithmPolicy(MessageEncryptionMechanismPolicy.Companion.rfc4880Plus9580PlusLibrePGP(symmetricKeyDecryptionAlgorithmPolicy));
        }

        @NotNull
        public final Builder withMessageEncryptionAlgorithmPolicy(@NotNull MessageEncryptionMechanismPolicy encryptionMechanismPolicy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encryptionMechanismPolicy, (String)"encryptionMechanismPolicy");
            Builder $this$withMessageEncryptionAlgorithmPolicy_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$withMessageEncryptionAlgorithmPolicy_u24lambda_u243.messageEncryptionMechanismPolicy = encryptionMechanismPolicy;
            return builder;
        }

        @NotNull
        public final Builder withMessageDecryptionAlgorithmPolicy(@NotNull MessageEncryptionMechanismPolicy decryptionMechanismPolicy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)decryptionMechanismPolicy, (String)"decryptionMechanismPolicy");
            Builder $this$withMessageDecryptionAlgorithmPolicy_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$withMessageDecryptionAlgorithmPolicy_u24lambda_u244.messageDecryptionMechanismPolicy = decryptionMechanismPolicy;
            return builder;
        }

        @NotNull
        public final Builder withCompressionAlgorithmPolicy(@NotNull CompressionAlgorithmPolicy compressionAlgorithmPolicy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)compressionAlgorithmPolicy, (String)"compressionAlgorithmPolicy");
            Builder $this$withCompressionAlgorithmPolicy_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$withCompressionAlgorithmPolicy_u24lambda_u245.compressionAlgorithmPolicy = compressionAlgorithmPolicy;
            return builder;
        }

        @NotNull
        public final Builder withPublicKeyAlgorithmPolicy(@NotNull PublicKeyAlgorithmPolicy publicKeyAlgorithmPolicy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)publicKeyAlgorithmPolicy, (String)"publicKeyAlgorithmPolicy");
            Builder $this$withPublicKeyAlgorithmPolicy_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$withPublicKeyAlgorithmPolicy_u24lambda_u246.publicKeyAlgorithmPolicy = publicKeyAlgorithmPolicy;
            return builder;
        }

        @NotNull
        public final Builder withKeyProtectionSettings(@NotNull KeyRingProtectionSettings keyProtectionSettings) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)keyProtectionSettings, (String)"keyProtectionSettings");
            Builder $this$withKeyProtectionSettings_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$withKeyProtectionSettings_u24lambda_u247.keyProtectionSettings = keyProtectionSettings;
            return builder;
        }

        @NotNull
        public final Builder withNotationRegistry(@NotNull NotationRegistry notationRegistry) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)notationRegistry, (String)"notationRegistry");
            Builder $this$withNotationRegistry_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$withNotationRegistry_u24lambda_u248.notationRegistry = notationRegistry;
            return builder;
        }

        @NotNull
        public final Builder withKeyGenerationAlgorithmSuite(@NotNull AlgorithmSuite keyGenerationAlgorithmSuite) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)keyGenerationAlgorithmSuite, (String)"keyGenerationAlgorithmSuite");
            Builder $this$withKeyGenerationAlgorithmSuite_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$withKeyGenerationAlgorithmSuite_u24lambda_u249.keyGenerationAlgorithmSuite = keyGenerationAlgorithmSuite;
            return builder;
        }

        @NotNull
        public final Policy build() {
            Policy policy;
            Policy $this$build_u24lambda_u2410 = policy = new Policy(this.certificationSignatureHashAlgorithmPolicy, this.revocationSignatureHashAlgorithmPolicy, this.dataSignatureHashAlgorithmPolicy, this.messageEncryptionMechanismPolicy, this.messageDecryptionMechanismPolicy, this.compressionAlgorithmPolicy, this.publicKeyAlgorithmPolicy, this.keyProtectionSettings, this.notationRegistry, this.keyGenerationAlgorithmSuite);
            boolean bl = false;
            $this$build_u24lambda_u2410.setEnableKeyParameterValidation(this.origin.getEnableKeyParameterValidation());
            return policy;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/policy/Policy$Companion;", "", "()V", "wildcardPolicy", "Lorg/pgpainless/policy/Policy;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Policy.kt\norg/pgpainless/policy/Policy$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,783:1\n1271#2,2:784\n1285#2,4:786\n*S KotlinDebug\n*F\n+ 1 Policy.kt\norg/pgpainless/policy/Policy$Companion\n*L\n777#1:784,2\n777#1:786,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Policy wildcardPolicy() {
            Map map;
            void $this$associateWith$iv;
            Object object = new SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.AES_256, (List)SymmetricKeyAlgorithm.getEntries());
            MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.integrityProtected((int)SymmetricKeyAlgorithm.AES_256.getAlgorithmId());
            MessageEncryptionMechanismPolicy messageEncryptionMechanismPolicy = new MessageEncryptionMechanismPolicy((SymmetricKeyAlgorithmPolicy)object, messageEncryptionMechanism){
                {
                    Intrinsics.checkNotNull((Object)$super_call_param$2);
                    super($super_call_param$1, $super_call_param$2, null, 4, null);
                }

                public boolean isAcceptable(@NotNull MessageEncryptionMechanism encryptionMechanism) {
                    Intrinsics.checkNotNullParameter((Object)encryptionMechanism, (String)"encryptionMechanism");
                    return true;
                }
            };
            object = new SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.AES_256, (List)SymmetricKeyAlgorithm.getEntries());
            messageEncryptionMechanism = MessageEncryptionMechanism.integrityProtected((int)SymmetricKeyAlgorithm.AES_256.getAlgorithmId());
            MessageEncryptionMechanismPolicy messageEncryptionMechanismPolicy2 = new MessageEncryptionMechanismPolicy((SymmetricKeyAlgorithmPolicy)object, messageEncryptionMechanism){
                {
                    Intrinsics.checkNotNull((Object)$super_call_param$2);
                    super($super_call_param$1, $super_call_param$2, null, 4, null);
                }

                public boolean isAcceptable(@NotNull MessageEncryptionMechanism encryptionMechanism) {
                    Intrinsics.checkNotNullParameter((Object)encryptionMechanism, (String)"encryptionMechanism");
                    return true;
                }
            };
            object = (Iterable)PublicKeyAlgorithm.getEntries();
            CompressionAlgorithmPolicy compressionAlgorithmPolicy = CompressionAlgorithmPolicy.Companion.anyCompressionAlgorithmPolicy();
            MessageEncryptionMechanismPolicy messageEncryptionMechanismPolicy3 = messageEncryptionMechanismPolicy2;
            MessageEncryptionMechanismPolicy messageEncryptionMechanismPolicy4 = messageEncryptionMechanismPolicy;
            HashAlgorithmPolicy hashAlgorithmPolicy = new HashAlgorithmPolicy(HashAlgorithm.SHA512, (List)HashAlgorithm.getEntries());
            HashAlgorithmPolicy hashAlgorithmPolicy2 = new HashAlgorithmPolicy(HashAlgorithm.SHA512, (List)HashAlgorithm.getEntries());
            HashAlgorithmPolicy hashAlgorithmPolicy3 = new HashAlgorithmPolicy(HashAlgorithm.SHA512, (List)HashAlgorithm.getEntries());
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                PublicKeyAlgorithm publicKeyAlgorithm = (PublicKeyAlgorithm)((Object)element$iv$iv);
                Object t = element$iv$iv;
                map = result$iv;
                boolean bl = false;
                Integer n = 0;
                map.put(t, n);
            }
            map = result$iv;
            Map map2 = MapsKt.toMap((Map)map);
            AlgorithmSuite algorithmSuite = AlgorithmSuite.Companion.getDefaultAlgorithmSuite();
            NotationRegistry notationRegistry = new NotationRegistry(SetsKt.emptySet());
            KeyRingProtectionSettings keyRingProtectionSettings = KeyRingProtectionSettings.Companion.secureDefaultSettings();
            PublicKeyAlgorithmPolicy publicKeyAlgorithmPolicy = new PublicKeyAlgorithmPolicy(map2);
            CompressionAlgorithmPolicy compressionAlgorithmPolicy2 = compressionAlgorithmPolicy;
            MessageEncryptionMechanismPolicy messageEncryptionMechanismPolicy5 = messageEncryptionMechanismPolicy3;
            MessageEncryptionMechanismPolicy messageEncryptionMechanismPolicy6 = messageEncryptionMechanismPolicy4;
            HashAlgorithmPolicy hashAlgorithmPolicy4 = hashAlgorithmPolicy;
            HashAlgorithmPolicy hashAlgorithmPolicy5 = hashAlgorithmPolicy2;
            HashAlgorithmPolicy hashAlgorithmPolicy6 = hashAlgorithmPolicy3;
            return new Policy(hashAlgorithmPolicy6, hashAlgorithmPolicy5, hashAlgorithmPolicy4, messageEncryptionMechanismPolicy6, messageEncryptionMechanismPolicy5, compressionAlgorithmPolicy2, publicKeyAlgorithmPolicy, keyRingProtectionSettings, notationRegistry, algorithmSuite);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/policy/Policy$CompressionAlgorithmPolicy;", "", "defaultCompressionAlgorithm", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "acceptableCompressionAlgorithms", "", "(Lorg/pgpainless/algorithm/CompressionAlgorithm;Ljava/util/List;)V", "getAcceptableCompressionAlgorithms", "()Ljava/util/List;", "getDefaultCompressionAlgorithm", "()Lorg/pgpainless/algorithm/CompressionAlgorithm;", "isAcceptable", "", "algorithmId", "", "algorithm", "Companion", "pgpainless-core"})
    public static final class CompressionAlgorithmPolicy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final CompressionAlgorithm defaultCompressionAlgorithm;
        @NotNull
        private final List<CompressionAlgorithm> acceptableCompressionAlgorithms;

        public CompressionAlgorithmPolicy(@NotNull CompressionAlgorithm defaultCompressionAlgorithm, @NotNull List<? extends CompressionAlgorithm> acceptableCompressionAlgorithms) {
            Intrinsics.checkNotNullParameter((Object)((Object)defaultCompressionAlgorithm), (String)"defaultCompressionAlgorithm");
            Intrinsics.checkNotNullParameter(acceptableCompressionAlgorithms, (String)"acceptableCompressionAlgorithms");
            this.defaultCompressionAlgorithm = defaultCompressionAlgorithm;
            this.acceptableCompressionAlgorithms = acceptableCompressionAlgorithms;
        }

        @NotNull
        public final CompressionAlgorithm getDefaultCompressionAlgorithm() {
            return this.defaultCompressionAlgorithm;
        }

        @NotNull
        public final List<CompressionAlgorithm> getAcceptableCompressionAlgorithms() {
            return this.acceptableCompressionAlgorithms;
        }

        public final boolean isAcceptable(@NotNull CompressionAlgorithm algorithm) {
            Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
            return this.acceptableCompressionAlgorithms.contains((Object)algorithm);
        }

        public final boolean isAcceptable(int algorithmId) {
            CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.Companion.fromId(algorithmId);
            if (compressionAlgorithm == null) {
                return false;
            }
            CompressionAlgorithm algorithm = compressionAlgorithm;
            return this.isAcceptable(algorithm);
        }

        @NotNull
        public final CompressionAlgorithm defaultCompressionAlgorithm() {
            return this.defaultCompressionAlgorithm;
        }

        @JvmStatic
        @Deprecated(message="not expressive - might be removed in a future release", replaceWith=@ReplaceWith(expression="anyCompressionAlgorithmPolicy()", imports={}))
        @NotNull
        public static final CompressionAlgorithmPolicy defaultCompressionAlgorithmPolicy() {
            return Companion.defaultCompressionAlgorithmPolicy();
        }

        @JvmStatic
        @NotNull
        public static final CompressionAlgorithmPolicy anyCompressionAlgorithmPolicy() {
            return Companion.anyCompressionAlgorithmPolicy();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/pgpainless/policy/Policy$CompressionAlgorithmPolicy$Companion;", "", "()V", "anyCompressionAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$CompressionAlgorithmPolicy;", "defaultCompressionAlgorithmPolicy", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Deprecated(message="not expressive - might be removed in a future release", replaceWith=@ReplaceWith(expression="anyCompressionAlgorithmPolicy()", imports={}))
            @NotNull
            public final CompressionAlgorithmPolicy defaultCompressionAlgorithmPolicy() {
                return this.anyCompressionAlgorithmPolicy();
            }

            @JvmStatic
            @NotNull
            public final CompressionAlgorithmPolicy anyCompressionAlgorithmPolicy() {
                CompressionAlgorithm[] compressionAlgorithmArray = new CompressionAlgorithm[]{CompressionAlgorithm.UNCOMPRESSED, CompressionAlgorithm.ZIP, CompressionAlgorithm.BZIP2, CompressionAlgorithm.ZLIB};
                return new CompressionAlgorithmPolicy(CompressionAlgorithm.UNCOMPRESSED, CollectionsKt.listOf((Object[])compressionAlgorithmArray));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lorg/pgpainless/policy/Policy$FeaturePolicy;", "", "()V", "isAcceptable", "", "feature", "", "Lorg/pgpainless/algorithm/Feature;", "Companion", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Policy.kt\norg/pgpainless/policy/Policy$FeaturePolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,783:1\n1#2:784\n*E\n"})
    public static abstract class FeaturePolicy {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public final boolean isAcceptable(byte feature) {
            boolean bl;
            Feature feature2 = Feature.Companion.fromId(feature);
            if (feature2 != null) {
                Feature it = feature2;
                boolean bl2 = false;
                bl = this.isAcceptable(it);
            } else {
                bl = false;
            }
            return bl;
        }

        public abstract boolean isAcceptable(@NotNull Feature var1);

        @JvmStatic
        @NotNull
        public static final FeaturePolicy defaultFeaturePolicy() {
            return Companion.defaultFeaturePolicy();
        }

        @JvmStatic
        @NotNull
        public static final FeaturePolicy whiteList(@NotNull List<? extends Feature> whitelistedFeatures) {
            return Companion.whiteList(whitelistedFeatures);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0016\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Lorg/pgpainless/policy/Policy$FeaturePolicy$Companion;", "", "()V", "defaultFeaturePolicy", "Lorg/pgpainless/policy/Policy$FeaturePolicy;", "whiteList", "whitelistedFeatures", "", "Lorg/pgpainless/algorithm/Feature;", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final FeaturePolicy defaultFeaturePolicy() {
                Feature[] featureArray = new Feature[]{Feature.MODIFICATION_DETECTION, Feature.MODIFICATION_DETECTION_2};
                return this.whiteList(CollectionsKt.listOf((Object[])featureArray));
            }

            @JvmStatic
            @NotNull
            public final FeaturePolicy whiteList(@NotNull List<? extends Feature> whitelistedFeatures) {
                Intrinsics.checkNotNullParameter(whitelistedFeatures, (String)"whitelistedFeatures");
                return new FeaturePolicy(whitelistedFeatures){
                    final /* synthetic */ List<Feature> $whitelistedFeatures;
                    {
                        this.$whitelistedFeatures = $whitelistedFeatures;
                    }

                    public boolean isAcceptable(@NotNull Feature feature) {
                        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
                        return this.$whitelistedFeatures.contains((Object)((Object)feature));
                    }
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\tR\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;", "", "defaultHashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "acceptableHashAlgorithms", "", "(Lorg/pgpainless/algorithm/HashAlgorithm;Ljava/util/List;)V", "acceptableHashAlgorithmsAndTerminationDates", "", "Ljava/util/Date;", "(Lorg/pgpainless/algorithm/HashAlgorithm;Ljava/util/Map;)V", "getAcceptableHashAlgorithmsAndTerminationDates", "()Ljava/util/Map;", "getDefaultHashAlgorithm", "()Lorg/pgpainless/algorithm/HashAlgorithm;", "isAcceptable", "", "algorithmId", "", "referenceTime", "hashAlgorithm", "Companion", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Policy.kt\norg/pgpainless/policy/Policy$HashAlgorithmPolicy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,783:1\n1271#2,2:784\n1285#2,4:786\n*S KotlinDebug\n*F\n+ 1 Policy.kt\norg/pgpainless/policy/Policy$HashAlgorithmPolicy\n*L\n148#1:784,2\n148#1:786,4\n*E\n"})
    public static final class HashAlgorithmPolicy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final HashAlgorithm defaultHashAlgorithm;
        @NotNull
        private final Map<HashAlgorithm, Date> acceptableHashAlgorithmsAndTerminationDates;

        public HashAlgorithmPolicy(@NotNull HashAlgorithm defaultHashAlgorithm, @NotNull Map<HashAlgorithm, ? extends Date> acceptableHashAlgorithmsAndTerminationDates) {
            Intrinsics.checkNotNullParameter((Object)((Object)defaultHashAlgorithm), (String)"defaultHashAlgorithm");
            Intrinsics.checkNotNullParameter(acceptableHashAlgorithmsAndTerminationDates, (String)"acceptableHashAlgorithmsAndTerminationDates");
            this.defaultHashAlgorithm = defaultHashAlgorithm;
            this.acceptableHashAlgorithmsAndTerminationDates = acceptableHashAlgorithmsAndTerminationDates;
        }

        @NotNull
        public final HashAlgorithm getDefaultHashAlgorithm() {
            return this.defaultHashAlgorithm;
        }

        @NotNull
        public final Map<HashAlgorithm, Date> getAcceptableHashAlgorithmsAndTerminationDates() {
            return this.acceptableHashAlgorithmsAndTerminationDates;
        }

        /*
         * WARNING - void declaration
         */
        public HashAlgorithmPolicy(@NotNull HashAlgorithm defaultHashAlgorithm, @NotNull List<? extends HashAlgorithm> acceptableHashAlgorithms) {
            Map map;
            void $this$associateWith$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)defaultHashAlgorithm), (String)"defaultHashAlgorithm");
            Intrinsics.checkNotNullParameter(acceptableHashAlgorithms, (String)"acceptableHashAlgorithms");
            Iterable iterable = acceptableHashAlgorithms;
            HashAlgorithm hashAlgorithm = defaultHashAlgorithm;
            HashAlgorithmPolicy hashAlgorithmPolicy = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                HashAlgorithm hashAlgorithm2 = (HashAlgorithm)((Object)element$iv$iv);
                Object t = element$iv$iv;
                map = result$iv;
                boolean bl = false;
                Object v = null;
                map.put(t, v);
            }
            map = result$iv;
            hashAlgorithmPolicy(hashAlgorithm, map);
        }

        public final boolean isAcceptable(@NotNull HashAlgorithm hashAlgorithm) {
            Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
            return this.isAcceptable(hashAlgorithm, new Date());
        }

        public final boolean isAcceptable(@NotNull HashAlgorithm hashAlgorithm, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            if (!this.acceptableHashAlgorithmsAndTerminationDates.containsKey((Object)hashAlgorithm)) {
                return false;
            }
            Date date = this.acceptableHashAlgorithmsAndTerminationDates.get((Object)hashAlgorithm);
            if (date == null) {
                return true;
            }
            Date terminationDate = date;
            return terminationDate.compareTo(referenceTime) > 0;
        }

        public final boolean isAcceptable(int algorithmId) {
            return this.isAcceptable(algorithmId, new Date());
        }

        public final boolean isAcceptable(int algorithmId, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            HashAlgorithm hashAlgorithm = HashAlgorithm.Companion.fromId(algorithmId);
            if (hashAlgorithm == null) {
                return false;
            }
            HashAlgorithm algorithm = hashAlgorithm;
            return this.isAcceptable(algorithm, referenceTime);
        }

        @NotNull
        public final HashAlgorithm defaultHashAlgorithm() {
            return this.defaultHashAlgorithm;
        }

        @JvmStatic
        @NotNull
        public static final HashAlgorithmPolicy smartCertificationSignatureHashAlgorithmPolicy() {
            return Companion.smartCertificationSignatureHashAlgorithmPolicy();
        }

        @JvmStatic
        @NotNull
        public static final HashAlgorithmPolicy smartDataSignatureHashAlgorithmPolicy() {
            return Companion.smartDataSignatureHashAlgorithmPolicy();
        }

        @JvmStatic
        @NotNull
        public static final HashAlgorithmPolicy smartSignatureHashAlgorithmPolicy() {
            return Companion.smartSignatureHashAlgorithmPolicy();
        }

        @JvmStatic
        @NotNull
        public static final HashAlgorithmPolicy static2022SignatureHashAlgorithmPolicy() {
            return Companion.static2022SignatureHashAlgorithmPolicy();
        }

        @JvmStatic
        @NotNull
        public static final HashAlgorithmPolicy static2022RevocationSignatureHashAlgorithmPolicy() {
            return Companion.static2022RevocationSignatureHashAlgorithmPolicy();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy$Companion;", "", "()V", "smartCertificationSignatureHashAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;", "smartDataSignatureHashAlgorithmPolicy", "smartSignatureHashAlgorithmPolicy", "static2022RevocationSignatureHashAlgorithmPolicy", "static2022SignatureHashAlgorithmPolicy", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public final HashAlgorithmPolicy smartCertificationSignatureHashAlgorithmPolicy() {
                void $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240;
                Map map;
                Map map2 = map = MapsKt.createMapBuilder();
                HashAlgorithm hashAlgorithm = HashAlgorithm.SHA512;
                boolean bl = false;
                $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.put(HashAlgorithm.SHA3_512, null);
                $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.put(HashAlgorithm.SHA3_512, null);
                $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.put(HashAlgorithm.SHA3_256, null);
                $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.put(HashAlgorithm.SHA512, null);
                $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.put(HashAlgorithm.SHA384, null);
                $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.put(HashAlgorithm.SHA256, null);
                $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.put(HashAlgorithm.SHA224, null);
                $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.put(HashAlgorithm.RIPEMD160, DateUtil.Companion.parseUTCDate("2023-02-01 00:00:00 UTC"));
                $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.put(HashAlgorithm.SHA1, DateUtil.Companion.parseUTCDate("2023-02-01 00:00:00 UTC"));
                $this$smartCertificationSignatureHashAlgorithmPolicy_u24lambda_u240.put(HashAlgorithm.MD5, DateUtil.Companion.parseUTCDate("1997-02-01 00:00:00 UTC"));
                Map map3 = MapsKt.build((Map)map);
                HashAlgorithm hashAlgorithm2 = hashAlgorithm;
                return new HashAlgorithmPolicy(hashAlgorithm2, map3);
            }

            @JvmStatic
            @NotNull
            public final HashAlgorithmPolicy smartDataSignatureHashAlgorithmPolicy() {
                return this.smartSignatureHashAlgorithmPolicy();
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public final HashAlgorithmPolicy smartSignatureHashAlgorithmPolicy() {
                void $this$smartSignatureHashAlgorithmPolicy_u24lambda_u241;
                Map map;
                Map map2 = map = MapsKt.createMapBuilder();
                HashAlgorithm hashAlgorithm = HashAlgorithm.SHA512;
                boolean bl = false;
                $this$smartSignatureHashAlgorithmPolicy_u24lambda_u241.put(HashAlgorithm.SHA3_512, null);
                $this$smartSignatureHashAlgorithmPolicy_u24lambda_u241.put(HashAlgorithm.SHA3_256, null);
                $this$smartSignatureHashAlgorithmPolicy_u24lambda_u241.put(HashAlgorithm.SHA512, null);
                $this$smartSignatureHashAlgorithmPolicy_u24lambda_u241.put(HashAlgorithm.SHA384, null);
                $this$smartSignatureHashAlgorithmPolicy_u24lambda_u241.put(HashAlgorithm.SHA256, null);
                $this$smartSignatureHashAlgorithmPolicy_u24lambda_u241.put(HashAlgorithm.SHA224, null);
                $this$smartSignatureHashAlgorithmPolicy_u24lambda_u241.put(HashAlgorithm.RIPEMD160, DateUtil.Companion.parseUTCDate("2013-02-01 00:00:00 UTC"));
                $this$smartSignatureHashAlgorithmPolicy_u24lambda_u241.put(HashAlgorithm.SHA1, DateUtil.Companion.parseUTCDate("2013-02-01 00:00:00 UTC"));
                $this$smartSignatureHashAlgorithmPolicy_u24lambda_u241.put(HashAlgorithm.MD5, DateUtil.Companion.parseUTCDate("1997-02-01 00:00:00 UTC"));
                Map map3 = MapsKt.build((Map)map);
                HashAlgorithm hashAlgorithm2 = hashAlgorithm;
                return new HashAlgorithmPolicy(hashAlgorithm2, map3);
            }

            @JvmStatic
            @NotNull
            public final HashAlgorithmPolicy static2022SignatureHashAlgorithmPolicy() {
                HashAlgorithm[] hashAlgorithmArray = new HashAlgorithm[]{HashAlgorithm.SHA3_512, HashAlgorithm.SHA3_256, HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256, HashAlgorithm.SHA224};
                return new HashAlgorithmPolicy(HashAlgorithm.SHA512, CollectionsKt.listOf((Object[])hashAlgorithmArray));
            }

            @JvmStatic
            @NotNull
            public final HashAlgorithmPolicy static2022RevocationSignatureHashAlgorithmPolicy() {
                HashAlgorithm[] hashAlgorithmArray = new HashAlgorithm[]{HashAlgorithm.SHA3_512, HashAlgorithm.SHA3_256, HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256, HashAlgorithm.SHA224, HashAlgorithm.SHA1, HashAlgorithm.RIPEMD160};
                return new HashAlgorithmPolicy(HashAlgorithm.SHA512, CollectionsKt.listOf((Object[])hashAlgorithmArray));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/policy/Policy$MessageEncryptionMechanismPolicy;", "", "symmetricAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;", "asymmetricFallbackMechanism", "Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;", "symmetricFallbackMechanism", "(Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;)V", "getAsymmetricFallbackMechanism", "()Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;", "getSymmetricAlgorithmPolicy", "()Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;", "getSymmetricFallbackMechanism", "isAcceptable", "", "encryptionMechanism", "Companion", "pgpainless-core"})
    public static abstract class MessageEncryptionMechanismPolicy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SymmetricKeyAlgorithmPolicy symmetricAlgorithmPolicy;
        @NotNull
        private final MessageEncryptionMechanism asymmetricFallbackMechanism;
        @NotNull
        private final MessageEncryptionMechanism symmetricFallbackMechanism;

        public MessageEncryptionMechanismPolicy(@NotNull SymmetricKeyAlgorithmPolicy symmetricAlgorithmPolicy, @NotNull MessageEncryptionMechanism asymmetricFallbackMechanism, @NotNull MessageEncryptionMechanism symmetricFallbackMechanism) {
            Intrinsics.checkNotNullParameter((Object)symmetricAlgorithmPolicy, (String)"symmetricAlgorithmPolicy");
            Intrinsics.checkNotNullParameter((Object)asymmetricFallbackMechanism, (String)"asymmetricFallbackMechanism");
            Intrinsics.checkNotNullParameter((Object)symmetricFallbackMechanism, (String)"symmetricFallbackMechanism");
            this.symmetricAlgorithmPolicy = symmetricAlgorithmPolicy;
            this.asymmetricFallbackMechanism = asymmetricFallbackMechanism;
            this.symmetricFallbackMechanism = symmetricFallbackMechanism;
        }

        public /* synthetic */ MessageEncryptionMechanismPolicy(SymmetricKeyAlgorithmPolicy symmetricKeyAlgorithmPolicy, MessageEncryptionMechanism messageEncryptionMechanism, MessageEncryptionMechanism messageEncryptionMechanism2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                messageEncryptionMechanism2 = messageEncryptionMechanism;
            }
            this(symmetricKeyAlgorithmPolicy, messageEncryptionMechanism, messageEncryptionMechanism2);
        }

        @NotNull
        public final SymmetricKeyAlgorithmPolicy getSymmetricAlgorithmPolicy() {
            return this.symmetricAlgorithmPolicy;
        }

        @NotNull
        public final MessageEncryptionMechanism getAsymmetricFallbackMechanism() {
            return this.asymmetricFallbackMechanism;
        }

        @NotNull
        public final MessageEncryptionMechanism getSymmetricFallbackMechanism() {
            return this.symmetricFallbackMechanism;
        }

        public abstract boolean isAcceptable(@NotNull MessageEncryptionMechanism var1);

        @JvmStatic
        @NotNull
        public static final MessageEncryptionMechanismPolicy rfc4880(@NotNull SymmetricKeyAlgorithmPolicy symAlgPolicy) {
            return Companion.rfc4880(symAlgPolicy);
        }

        @JvmStatic
        @NotNull
        public static final MessageEncryptionMechanismPolicy rfc9580(@NotNull SymmetricKeyAlgorithmPolicy symAlgPolicy) {
            return Companion.rfc9580(symAlgPolicy);
        }

        @JvmStatic
        @NotNull
        public static final MessageEncryptionMechanismPolicy librePgp(@NotNull SymmetricKeyAlgorithmPolicy symAlgPolicy) {
            return Companion.librePgp(symAlgPolicy);
        }

        @JvmStatic
        @NotNull
        public static final MessageEncryptionMechanismPolicy rfc4880Plus9580(@NotNull SymmetricKeyAlgorithmPolicy symAlgPolicy) {
            return Companion.rfc4880Plus9580(symAlgPolicy);
        }

        @JvmStatic
        @NotNull
        public static final MessageEncryptionMechanismPolicy rfc4880Plus9580PlusLibrePGP(@NotNull SymmetricKeyAlgorithmPolicy symAlgPolicy) {
            return Companion.rfc4880Plus9580PlusLibrePGP(symAlgPolicy);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/policy/Policy$MessageEncryptionMechanismPolicy$Companion;", "", "()V", "librePgp", "Lorg/pgpainless/policy/Policy$MessageEncryptionMechanismPolicy;", "symAlgPolicy", "Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;", "rfc4880", "rfc4880Plus9580", "rfc4880Plus9580PlusLibrePGP", "rfc9580", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final MessageEncryptionMechanismPolicy rfc4880(@NotNull SymmetricKeyAlgorithmPolicy symAlgPolicy) {
                Intrinsics.checkNotNullParameter((Object)symAlgPolicy, (String)"symAlgPolicy");
                MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.integrityProtected((int)symAlgPolicy.getDefaultSymmetricKeyAlgorithm().getAlgorithmId());
                return new MessageEncryptionMechanismPolicy(symAlgPolicy, messageEncryptionMechanism){
                    final /* synthetic */ SymmetricKeyAlgorithmPolicy $symAlgPolicy;
                    {
                        this.$symAlgPolicy = $symAlgPolicy;
                        Intrinsics.checkNotNull((Object)$super_call_param$1);
                        super($symAlgPolicy, $super_call_param$1, null, 4, null);
                    }

                    public boolean isAcceptable(@NotNull MessageEncryptionMechanism encryptionMechanism) {
                        Intrinsics.checkNotNullParameter((Object)encryptionMechanism, (String)"encryptionMechanism");
                        return encryptionMechanism.getMode() == EncryptedDataPacketType.SEIPDv1 && this.$symAlgPolicy.isAcceptable(encryptionMechanism.getSymmetricKeyAlgorithm());
                    }
                };
            }

            @JvmStatic
            @NotNull
            public final MessageEncryptionMechanismPolicy rfc9580(@NotNull SymmetricKeyAlgorithmPolicy symAlgPolicy) {
                Intrinsics.checkNotNullParameter((Object)symAlgPolicy, (String)"symAlgPolicy");
                MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.aead((int)symAlgPolicy.getDefaultSymmetricKeyAlgorithm().getAlgorithmId(), (int)AEADAlgorithm.OCB.getAlgorithmId());
                return new MessageEncryptionMechanismPolicy(symAlgPolicy, messageEncryptionMechanism){
                    @NotNull
                    private final List<Integer> acceptableAEADAlgorithms;
                    final /* synthetic */ SymmetricKeyAlgorithmPolicy $symAlgPolicy;
                    {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        this.$symAlgPolicy = $symAlgPolicy;
                        Intrinsics.checkNotNull((Object)$super_call_param$1);
                        super($symAlgPolicy, $super_call_param$1, null, 4, null);
                        Object object = new AEADAlgorithm[]{AEADAlgorithm.OCB, AEADAlgorithm.GCM, AEADAlgorithm.EAX};
                        object = CollectionsKt.listOf((Object[])object);
                        rfc9580.1 var12_4 = this;
                        boolean $i$f$map = false;
                        void var5_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            AEADAlgorithm aEADAlgorithm = (AEADAlgorithm)((Object)item$iv$iv);
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getAlgorithmId());
                        }
                        var12_4.acceptableAEADAlgorithms = (List)destination$iv$iv;
                    }

                    @NotNull
                    public final List<Integer> getAcceptableAEADAlgorithms() {
                        return this.acceptableAEADAlgorithms;
                    }

                    public boolean isAcceptable(@NotNull MessageEncryptionMechanism encryptionMechanism) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)encryptionMechanism, (String)"encryptionMechanism");
                        EncryptedDataPacketType encryptedDataPacketType = encryptionMechanism.getMode();
                        switch (encryptedDataPacketType == null ? -1 : rfc9580.WhenMappings.$EnumSwitchMapping$0[encryptedDataPacketType.ordinal()]) {
                            case 1: {
                                bl = this.$symAlgPolicy.isAcceptable(encryptionMechanism.getSymmetricKeyAlgorithm());
                                break;
                            }
                            case 2: {
                                if (this.$symAlgPolicy.isAcceptable(encryptionMechanism.getSymmetricKeyAlgorithm()) && this.acceptableAEADAlgorithms.contains(encryptionMechanism.getAeadAlgorithm())) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            default: {
                                bl = false;
                            }
                        }
                        return bl;
                    }
                };
            }

            @JvmStatic
            @NotNull
            public final MessageEncryptionMechanismPolicy librePgp(@NotNull SymmetricKeyAlgorithmPolicy symAlgPolicy) {
                Intrinsics.checkNotNullParameter((Object)symAlgPolicy, (String)"symAlgPolicy");
                MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.integrityProtected((int)symAlgPolicy.getDefaultSymmetricKeyAlgorithm().getAlgorithmId());
                return new MessageEncryptionMechanismPolicy(symAlgPolicy, messageEncryptionMechanism){
                    @NotNull
                    private final List<Integer> acceptableAEADAlgorithms;
                    final /* synthetic */ SymmetricKeyAlgorithmPolicy $symAlgPolicy;
                    {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        this.$symAlgPolicy = $symAlgPolicy;
                        Intrinsics.checkNotNull((Object)$super_call_param$1);
                        super($symAlgPolicy, $super_call_param$1, null, 4, null);
                        Iterable iterable = CollectionsKt.listOf((Object)((Object)AEADAlgorithm.OCB));
                        librePgp.1 var12_4 = this;
                        boolean $i$f$map = false;
                        void var5_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            AEADAlgorithm aEADAlgorithm = (AEADAlgorithm)((Object)item$iv$iv);
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getAlgorithmId());
                        }
                        var12_4.acceptableAEADAlgorithms = (List)destination$iv$iv;
                    }

                    @NotNull
                    public final List<Integer> getAcceptableAEADAlgorithms() {
                        return this.acceptableAEADAlgorithms;
                    }

                    public boolean isAcceptable(@NotNull MessageEncryptionMechanism encryptionMechanism) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)encryptionMechanism, (String)"encryptionMechanism");
                        EncryptedDataPacketType encryptedDataPacketType = encryptionMechanism.getMode();
                        switch (encryptedDataPacketType == null ? -1 : librePgp.WhenMappings.$EnumSwitchMapping$0[encryptedDataPacketType.ordinal()]) {
                            case 1: {
                                bl = this.$symAlgPolicy.isAcceptable(encryptionMechanism.getSymmetricKeyAlgorithm());
                                break;
                            }
                            case 2: {
                                if (this.$symAlgPolicy.isAcceptable(encryptionMechanism.getSymmetricKeyAlgorithm()) && this.acceptableAEADAlgorithms.contains(encryptionMechanism.getAeadAlgorithm())) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            default: {
                                bl = false;
                            }
                        }
                        return bl;
                    }
                };
            }

            @JvmStatic
            @NotNull
            public final MessageEncryptionMechanismPolicy rfc4880Plus9580(@NotNull SymmetricKeyAlgorithmPolicy symAlgPolicy) {
                Intrinsics.checkNotNullParameter((Object)symAlgPolicy, (String)"symAlgPolicy");
                MessageEncryptionMechanismPolicy rfc48802 = this.rfc4880(symAlgPolicy);
                MessageEncryptionMechanismPolicy rfc95802 = this.rfc9580(symAlgPolicy);
                MessageEncryptionMechanism messageEncryptionMechanism = rfc48802.getAsymmetricFallbackMechanism();
                MessageEncryptionMechanism messageEncryptionMechanism2 = rfc48802.getSymmetricFallbackMechanism();
                return new MessageEncryptionMechanismPolicy(symAlgPolicy, rfc95802, rfc48802, messageEncryptionMechanism, messageEncryptionMechanism2){
                    final /* synthetic */ MessageEncryptionMechanismPolicy $rfc9580;
                    final /* synthetic */ MessageEncryptionMechanismPolicy $rfc4880;
                    {
                        this.$rfc9580 = $rfc9580;
                        this.$rfc4880 = $rfc4880;
                        super($symAlgPolicy, $super_call_param$1, $super_call_param$2);
                    }

                    public boolean isAcceptable(@NotNull MessageEncryptionMechanism encryptionMechanism) {
                        Intrinsics.checkNotNullParameter((Object)encryptionMechanism, (String)"encryptionMechanism");
                        return this.$rfc9580.isAcceptable(encryptionMechanism) || this.$rfc4880.isAcceptable(encryptionMechanism);
                    }
                };
            }

            @JvmStatic
            @NotNull
            public final MessageEncryptionMechanismPolicy rfc4880Plus9580PlusLibrePGP(@NotNull SymmetricKeyAlgorithmPolicy symAlgPolicy) {
                Intrinsics.checkNotNullParameter((Object)symAlgPolicy, (String)"symAlgPolicy");
                MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.integrityProtected((int)symAlgPolicy.getDefaultSymmetricKeyAlgorithm().getAlgorithmId());
                return new MessageEncryptionMechanismPolicy(symAlgPolicy, messageEncryptionMechanism){
                    final /* synthetic */ SymmetricKeyAlgorithmPolicy $symAlgPolicy;
                    {
                        this.$symAlgPolicy = $symAlgPolicy;
                        Intrinsics.checkNotNull((Object)$super_call_param$1);
                        super($symAlgPolicy, $super_call_param$1, null, 4, null);
                    }

                    public boolean isAcceptable(@NotNull MessageEncryptionMechanism encryptionMechanism) {
                        Intrinsics.checkNotNullParameter((Object)encryptionMechanism, (String)"encryptionMechanism");
                        MessageEncryptionMechanismPolicy rfc4480 = MessageEncryptionMechanismPolicy.Companion.rfc4880(this.$symAlgPolicy);
                        MessageEncryptionMechanismPolicy rfc95802 = MessageEncryptionMechanismPolicy.Companion.rfc9580(this.$symAlgPolicy);
                        MessageEncryptionMechanismPolicy librePgp2 = MessageEncryptionMechanismPolicy.Companion.librePgp(this.$symAlgPolicy);
                        return rfc4480.isAcceptable(encryptionMechanism) || rfc95802.isAcceptable(encryptionMechanism) || librePgp2.isAcceptable(encryptionMechanism);
                    }
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/pgpainless/policy/Policy$PublicKeyAlgorithmPolicy;", "", "algorithmStrengths", "", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "", "(Ljava/util/Map;)V", "isAcceptable", "", "algorithmId", "bitStrength", "algorithm", "Companion", "pgpainless-core"})
    public static final class PublicKeyAlgorithmPolicy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<PublicKeyAlgorithm, Integer> algorithmStrengths;

        public PublicKeyAlgorithmPolicy(@NotNull Map<PublicKeyAlgorithm, Integer> algorithmStrengths) {
            Intrinsics.checkNotNullParameter(algorithmStrengths, (String)"algorithmStrengths");
            this.algorithmStrengths = algorithmStrengths;
        }

        public final boolean isAcceptable(@NotNull PublicKeyAlgorithm algorithm, int bitStrength) {
            Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
            Integer n = this.algorithmStrengths.get((Object)algorithm);
            if (n == null) {
                return false;
            }
            return bitStrength >= n;
        }

        public final boolean isAcceptable(int algorithmId, int bitStrength) {
            PublicKeyAlgorithm publicKeyAlgorithm = PublicKeyAlgorithm.Companion.fromId(algorithmId);
            if (publicKeyAlgorithm == null) {
                return false;
            }
            PublicKeyAlgorithm algorithm = publicKeyAlgorithm;
            return this.isAcceptable(algorithm, bitStrength);
        }

        @JvmStatic
        @Deprecated(message="not expressive - might be removed in a future release", replaceWith=@ReplaceWith(expression="rfc9580PublicKeyAlgorithmPolicy()", imports={}))
        @NotNull
        public static final PublicKeyAlgorithmPolicy defaultPublicKeyAlgorithmPolicy() {
            return Companion.defaultPublicKeyAlgorithmPolicy();
        }

        @JvmStatic
        @NotNull
        public static final PublicKeyAlgorithmPolicy bsi2021PublicKeyAlgorithmPolicy() {
            return Companion.bsi2021PublicKeyAlgorithmPolicy();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/policy/Policy$PublicKeyAlgorithmPolicy$Companion;", "", "()V", "bsi2021PublicKeyAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$PublicKeyAlgorithmPolicy;", "defaultPublicKeyAlgorithmPolicy", "rfc9580PublicKeyAlgorithmPolicy", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Deprecated(message="not expressive - might be removed in a future release", replaceWith=@ReplaceWith(expression="rfc9580PublicKeyAlgorithmPolicy()", imports={}))
            @NotNull
            public final PublicKeyAlgorithmPolicy defaultPublicKeyAlgorithmPolicy() {
                return this.rfc9580PublicKeyAlgorithmPolicy();
            }

            @JvmStatic
            @NotNull
            public final PublicKeyAlgorithmPolicy bsi2021PublicKeyAlgorithmPolicy() {
                Map map;
                Map $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240 = map = MapsKt.createMapBuilder();
                boolean bl = false;
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.RSA_GENERAL, 2000);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.RSA_SIGN, 2000);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.RSA_ENCRYPT, 2000);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.ELGAMAL_ENCRYPT, 2000);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.ELGAMAL_GENERAL, 2000);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.DSA, 2000);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.ECDSA, 250);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.EDDSA_LEGACY, 250);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.DIFFIE_HELLMAN, 2000);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.ECDH, 250);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.X25519, 256);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.ED25519, 256);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.X448, 448);
                $this$bsi2021PublicKeyAlgorithmPolicy_u24lambda_u240.put(PublicKeyAlgorithm.ED448, 456);
                Map map2 = MapsKt.build((Map)map);
                return new PublicKeyAlgorithmPolicy(map2);
            }

            @NotNull
            public final PublicKeyAlgorithmPolicy rfc9580PublicKeyAlgorithmPolicy() {
                Map map;
                Map $this$rfc9580PublicKeyAlgorithmPolicy_u24lambda_u241 = map = MapsKt.createMapBuilder();
                boolean bl = false;
                $this$rfc9580PublicKeyAlgorithmPolicy_u24lambda_u241.put(PublicKeyAlgorithm.RSA_GENERAL, 2000);
                $this$rfc9580PublicKeyAlgorithmPolicy_u24lambda_u241.put(PublicKeyAlgorithm.EDDSA_LEGACY, 250);
                $this$rfc9580PublicKeyAlgorithmPolicy_u24lambda_u241.put(PublicKeyAlgorithm.ECDH, 250);
                $this$rfc9580PublicKeyAlgorithmPolicy_u24lambda_u241.put(PublicKeyAlgorithm.ECDSA, 250);
                $this$rfc9580PublicKeyAlgorithmPolicy_u24lambda_u241.put(PublicKeyAlgorithm.X25519, 256);
                $this$rfc9580PublicKeyAlgorithmPolicy_u24lambda_u241.put(PublicKeyAlgorithm.ED25519, 256);
                $this$rfc9580PublicKeyAlgorithmPolicy_u24lambda_u241.put(PublicKeyAlgorithm.X448, 448);
                $this$rfc9580PublicKeyAlgorithmPolicy_u24lambda_u241.put(PublicKeyAlgorithm.ED448, 456);
                Map map2 = MapsKt.build((Map)map);
                return new PublicKeyAlgorithmPolicy(map2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;", "", "defaultSymmetricKeyAlgorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "acceptableSymmetricKeyAlgorithms", "", "(Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;Ljava/util/List;)V", "getAcceptableSymmetricKeyAlgorithms", "()Ljava/util/List;", "getDefaultSymmetricKeyAlgorithm", "()Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "isAcceptable", "", "algorithmId", "", "algorithm", "selectBest", "options", "Companion", "pgpainless-core"})
    public static final class SymmetricKeyAlgorithmPolicy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SymmetricKeyAlgorithm defaultSymmetricKeyAlgorithm;
        @NotNull
        private final List<SymmetricKeyAlgorithm> acceptableSymmetricKeyAlgorithms;

        public SymmetricKeyAlgorithmPolicy(@NotNull SymmetricKeyAlgorithm defaultSymmetricKeyAlgorithm, @NotNull List<? extends SymmetricKeyAlgorithm> acceptableSymmetricKeyAlgorithms) {
            Intrinsics.checkNotNullParameter((Object)((Object)defaultSymmetricKeyAlgorithm), (String)"defaultSymmetricKeyAlgorithm");
            Intrinsics.checkNotNullParameter(acceptableSymmetricKeyAlgorithms, (String)"acceptableSymmetricKeyAlgorithms");
            this.defaultSymmetricKeyAlgorithm = defaultSymmetricKeyAlgorithm;
            this.acceptableSymmetricKeyAlgorithms = acceptableSymmetricKeyAlgorithms;
        }

        @NotNull
        public final SymmetricKeyAlgorithm getDefaultSymmetricKeyAlgorithm() {
            return this.defaultSymmetricKeyAlgorithm;
        }

        @NotNull
        public final List<SymmetricKeyAlgorithm> getAcceptableSymmetricKeyAlgorithms() {
            return this.acceptableSymmetricKeyAlgorithms;
        }

        public final boolean isAcceptable(@NotNull SymmetricKeyAlgorithm algorithm) {
            Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
            return this.acceptableSymmetricKeyAlgorithms.contains((Object)algorithm);
        }

        public final boolean isAcceptable(int algorithmId) {
            SymmetricKeyAlgorithm symmetricKeyAlgorithm = SymmetricKeyAlgorithm.Companion.fromId(algorithmId);
            if (symmetricKeyAlgorithm == null) {
                return false;
            }
            SymmetricKeyAlgorithm algorithm = symmetricKeyAlgorithm;
            return this.isAcceptable(algorithm);
        }

        @Nullable
        public final SymmetricKeyAlgorithm selectBest(@NotNull List<? extends SymmetricKeyAlgorithm> options) {
            Intrinsics.checkNotNullParameter(options, (String)"options");
            for (SymmetricKeyAlgorithm acceptable : this.acceptableSymmetricKeyAlgorithms) {
                if (!options.contains((Object)acceptable)) continue;
                return acceptable;
            }
            return null;
        }

        @JvmStatic
        @Deprecated(message="Not expressive - will be removed in a future release", replaceWith=@ReplaceWith(expression="symmetricKeyEncryptionPolicy2022", imports={}))
        @NotNull
        public static final SymmetricKeyAlgorithmPolicy defaultSymmetricKeyEncryptionAlgorithmPolicy() {
            return Companion.defaultSymmetricKeyEncryptionAlgorithmPolicy();
        }

        @JvmStatic
        @NotNull
        public static final SymmetricKeyAlgorithmPolicy symmetricKeyEncryptionPolicy2022() {
            return Companion.symmetricKeyEncryptionPolicy2022();
        }

        @JvmStatic
        @Deprecated(message="not expressive - will be removed in a future update", replaceWith=@ReplaceWith(expression="symmetricKeyDecryptionPolicy2022()", imports={}))
        @NotNull
        public static final SymmetricKeyAlgorithmPolicy defaultSymmetricKeyDecryptionAlgorithmPolicy() {
            return Companion.defaultSymmetricKeyDecryptionAlgorithmPolicy();
        }

        @JvmStatic
        @NotNull
        public static final SymmetricKeyAlgorithmPolicy symmetricKeyDecryptionPolicy2022() {
            return Companion.symmetricKeyDecryptionPolicy2022();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy$Companion;", "", "()V", "defaultSymmetricKeyDecryptionAlgorithmPolicy", "Lorg/pgpainless/policy/Policy$SymmetricKeyAlgorithmPolicy;", "defaultSymmetricKeyEncryptionAlgorithmPolicy", "symmetricKeyDecryptionPolicy2022", "symmetricKeyEncryptionPolicy2022", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Deprecated(message="Not expressive - will be removed in a future release", replaceWith=@ReplaceWith(expression="symmetricKeyEncryptionPolicy2022", imports={}))
            @NotNull
            public final SymmetricKeyAlgorithmPolicy defaultSymmetricKeyEncryptionAlgorithmPolicy() {
                return this.symmetricKeyEncryptionPolicy2022();
            }

            @JvmStatic
            @NotNull
            public final SymmetricKeyAlgorithmPolicy symmetricKeyEncryptionPolicy2022() {
                SymmetricKeyAlgorithm[] symmetricKeyAlgorithmArray = new SymmetricKeyAlgorithm[]{SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128, SymmetricKeyAlgorithm.TWOFISH, SymmetricKeyAlgorithm.CAMELLIA_256, SymmetricKeyAlgorithm.CAMELLIA_192, SymmetricKeyAlgorithm.CAMELLIA_128};
                return new SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.AES_128, CollectionsKt.listOf((Object[])symmetricKeyAlgorithmArray));
            }

            @JvmStatic
            @Deprecated(message="not expressive - will be removed in a future update", replaceWith=@ReplaceWith(expression="symmetricKeyDecryptionPolicy2022()", imports={}))
            @NotNull
            public final SymmetricKeyAlgorithmPolicy defaultSymmetricKeyDecryptionAlgorithmPolicy() {
                return this.symmetricKeyDecryptionPolicy2022();
            }

            @JvmStatic
            @NotNull
            public final SymmetricKeyAlgorithmPolicy symmetricKeyDecryptionPolicy2022() {
                SymmetricKeyAlgorithm[] symmetricKeyAlgorithmArray = new SymmetricKeyAlgorithm[]{SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128, SymmetricKeyAlgorithm.TWOFISH, SymmetricKeyAlgorithm.CAMELLIA_256, SymmetricKeyAlgorithm.CAMELLIA_192, SymmetricKeyAlgorithm.CAMELLIA_128, SymmetricKeyAlgorithm.CAST5};
                return new SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.AES_128, CollectionsKt.listOf((Object[])symmetricKeyAlgorithmArray));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

