/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection.fixes;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.bouncycastle.extensions.OpenPGPImplementationExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/key/protection/fixes/S2KUsageFix;", "", "()V", "Companion", "pgpainless-core"})
public final class S2KUsageFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPSecretKeyRing replaceUsageChecksumWithUsageSha1(@NotNull PGPSecretKeyRing keys, @NotNull SecretKeyRingProtector protector, boolean skipKeysWithMissingPassphrase) {
        return Companion.replaceUsageChecksumWithUsageSha1(keys, protector, skipKeysWithMissingPassphrase);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPSecretKeyRing replaceUsageChecksumWithUsageSha1(@NotNull PGPSecretKeyRing keys, @NotNull SecretKeyRingProtector protector) {
        return Companion.replaceUsageChecksumWithUsageSha1(keys, protector);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/pgpainless/key/protection/fixes/S2KUsageFix$Companion;", "", "()V", "replaceUsageChecksumWithUsageSha1", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "keys", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "skipKeysWithMissingPassphrase", "", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPSecretKeyRing replaceUsageChecksumWithUsageSha1(@NotNull PGPSecretKeyRing keys, @NotNull SecretKeyRingProtector protector, boolean skipKeysWithMissingPassphrase) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            OpenPGPImplementation openPGPImplementation = OpenPGPImplementation.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)openPGPImplementation, (String)"getInstance(...)");
            PGPDigestCalculator digestCalculator = OpenPGPImplementationExtensionsKt.checksumCalculator(openPGPImplementation);
            List keyList = new ArrayList();
            for (PGPSecretKey key : keys) {
                if (key.getS2KUsage() != 255) {
                    Intrinsics.checkNotNull((Object)key);
                    keyList.add(key);
                    continue;
                }
                long keyId = key.getKeyID();
                PGPPublicKey pGPPublicKey = key.getPublicKey();
                Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
                PBESecretKeyEncryptor encryptor = protector.getEncryptor(pGPPublicKey);
                if (encryptor == null) {
                    if (skipKeysWithMissingPassphrase) {
                        Intrinsics.checkNotNull((Object)key);
                        keyList.add(key);
                        continue;
                    }
                    throw new WrongPassphraseException("Missing passphrase for key with ID " + Long.toHexString(keyId));
                }
                if (key.isPrivateKeyEmpty()) {
                    Intrinsics.checkNotNull((Object)key);
                    keyList.add(key);
                    continue;
                }
                Intrinsics.checkNotNull((Object)key);
                PGPPrivateKey privateKey = PGPSecretKeyExtensionsKt.unlock(key, protector);
                PGPPublicKey pGPPublicKey2 = key.getPublicKey();
                boolean bl = key.isMasterKey();
                PGPPublicKey pGPPublicKey3 = key.getPublicKey();
                Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey3, (String)"getPublicKey(...)");
                PGPSecretKey fixedKey = new PGPSecretKey(privateKey, pGPPublicKey2, digestCalculator, bl, protector.getEncryptor(pGPPublicKey3));
                keyList.add(fixedKey);
            }
            return new PGPSecretKeyRing(keyList);
        }

        public static /* synthetic */ PGPSecretKeyRing replaceUsageChecksumWithUsageSha1$default(Companion companion, PGPSecretKeyRing pGPSecretKeyRing, SecretKeyRingProtector secretKeyRingProtector, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.replaceUsageChecksumWithUsageSha1(pGPSecretKeyRing, secretKeyRingProtector, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPSecretKeyRing replaceUsageChecksumWithUsageSha1(@NotNull PGPSecretKeyRing keys, @NotNull SecretKeyRingProtector protector) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            return org.pgpainless.key.protection.fixes.S2KUsageFix$Companion.replaceUsageChecksumWithUsageSha1$default(this, keys, protector, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

